/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.ui.properties.widgets;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceFactory;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdvicePackage;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.FeatureToSet;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.ui.properties.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class StereotypesToApplyEditor
extends MultipleReferenceEditor {
    private Menu addMenu;

    public StereotypesToApplyEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected void createListControls() {
        this.up = this.createButton(Activator.getDefault().getImage("/icons/Up_12x12.gif"), Messages.StereotypesToApplyEditor_MoveSelectedElementsUp);
        this.down = this.createButton(Activator.getDefault().getImage("/icons/Down_12x12.gif"), Messages.StereotypesToApplyEditor_MoveSelectedElementsDown);
        this.add = this.createButton(Activator.getDefault().getImage("/icons/Add_12x12.gif"), Messages.StereotypesToApplyEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage("/icons/Delete_12x12.gif"), Messages.StereotypesToApplyEditor_RemoveSelectedElements);
    }

    protected void populateAddMenu() {
        this.createMenuItem(Activator.getDefault().getImage("org.eclipse.papyrus.uml.types.core", "/icons/full/obj16/StereotypeToApply.gif"), Messages.StereotypesToApplyEditor_AddStereotypeToApplyTitle, Messages.StereotypesToApplyEditor_AddStereotypeToApplyTooltip, ApplyStereotypeAdvicePackage.eINSTANCE.getApplyStereotypeAdviceConfiguration_StereotypesToApply());
        Object selection = ((ITreeSelection)this.getViewer().getSelection()).getFirstElement();
        if (selection != null) {
            this.createMenuItem(Activator.getDefault().getImage("org.eclipse.papyrus.uml.types.core", "/icons/full/obj16/FeatureToSet.gif"), Messages.StereotypesToApplyEditor_AddFeatureToSetTitle, Messages.StereotypesToApplyEditor_AddFeatureToSetTooltip, ApplyStereotypeAdvicePackage.eINSTANCE.getStereotypeToApply_FeaturesToSet());
        }
    }

    protected void createMenuItem(Image image, String text, String tooltipMessage, Object feature) {
        MenuItem stereotypeMenuItem = new MenuItem(this.addMenu, 0);
        stereotypeMenuItem.setText(text);
        stereotypeMenuItem.setImage(image);
        stereotypeMenuItem.setToolTipText(tooltipMessage);
        stereotypeMenuItem.setData(feature);
        stereotypeMenuItem.addSelectionListener((SelectionListener)this);
    }

    protected void addAction() {
        Object selection = ((ITreeSelection)this.getViewer().getSelection()).getFirstElement();
        if (selection != null) {
            this.addMenu = new Menu((Control)this.add);
            this.populateAddMenu();
            this.addMenu.setVisible(true);
        } else {
            EReference feature = ApplyStereotypeAdvicePackage.eINSTANCE.getApplyStereotypeAdviceConfiguration_StereotypesToApply();
            EObject container = (EObject)this.getContextElement();
            StereotypeToApply newObject = ApplyStereotypeAdviceFactory.eINSTANCE.createStereotypeToApply();
            this.addNewObject((EStructuralFeature)feature, container, newObject);
            this.getViewer().refresh();
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)newObject), true);
        }
    }

    protected void removeAction() {
        Object selection = ((ITreeSelection)this.getViewer().getSelection()).getFirstElement();
        if (selection instanceof FeatureToSet) {
            StereotypeToApply container = (StereotypeToApply)((FeatureToSet)selection).eContainer();
            RemoveCommand command = new RemoveCommand(this.getEditingDomain(), container.getFeaturesToSet(), selection);
            if (command != null && command.canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)command);
                this.getViewer().refresh();
                this.getViewer().setSelection((ISelection)new StructuredSelection((Object)container), true);
            }
        } else {
            super.removeAction();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        super.widgetSelected(event);
        if (event.getSource() instanceof MenuItem) {
            MenuItem selectedItem = (MenuItem)event.getSource();
            Object data = selectedItem.getData();
            EObject container = null;
            StereotypeToApply newObject = null;
            Object selection = ((ITreeSelection)this.getViewer().getSelection()).getFirstElement();
            if (ApplyStereotypeAdvicePackage.eINSTANCE.getApplyStereotypeAdviceConfiguration_StereotypesToApply().equals(data)) {
                newObject = ApplyStereotypeAdviceFactory.eINSTANCE.createStereotypeToApply();
                container = (EObject)this.getContextElement();
            } else if (ApplyStereotypeAdvicePackage.eINSTANCE.getStereotypeToApply_FeaturesToSet().equals(data)) {
                newObject = ApplyStereotypeAdviceFactory.eINSTANCE.createFeatureToSet();
                if (selection instanceof StereotypeToApply) {
                    container = (EObject)selection;
                } else if (selection instanceof FeatureToSet) {
                    container = ((EObject)selection).eContainer();
                }
            }
            if (data instanceof EStructuralFeature && container != null && newObject != null) {
                this.addNewObject((EStructuralFeature)data, container, newObject);
                this.getViewer().refresh();
                this.getViewer().expandToLevel((Object)container, 2);
                this.getViewer().setSelection((ISelection)new StructuredSelection((Object)newObject), true);
            }
        }
    }

    protected void addNewObject(EStructuralFeature structuralFeature, EObject container, Object newObject) {
        AddCommand command = null;
        EditingDomain editingDomain = this.getEditingDomain();
        if (container != null && structuralFeature != null && newObject != null) {
            command = new AddCommand(editingDomain, container, structuralFeature, newObject);
        }
        if (command != null && command.canExecute()) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    protected EditingDomain getEditingDomain() {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)this.getContextElement()));
    }
}

