/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.ui.properties.modelelement;

import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableValue;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.properties.widgets.ProfileExplorerDialog;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdvicePackage;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.ui.properties.providers.RequiredProfilesLabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Profile;

public class StereotypeToApplyModelElement
extends EMFModelElement {
    public StereotypeToApplyModelElement(EObject sourceElement, EditingDomain domain) {
        super(sourceElement, domain);
    }

    protected IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        if ("stereotypeQualifiedName".equals(propertyPath)) {
            observable = new StereotypeQualifyNameObsevableValue(this.source, this.getDomain());
        }
        return observable != null ? observable : super.doGetObservable(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        RequiredProfilesLabelProvider labelProvider = null;
        if ("requiredProfiles".equals(propertyPath)) {
            labelProvider = new RequiredProfilesLabelProvider();
        }
        return labelProvider != null ? labelProvider : super.getLabelProvider(propertyPath);
    }

    public boolean getDirectCreation(String propertyPath) {
        return true;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        ReferenceValueFactory valueFactory = null;
        if ("requiredProfiles".equals(propertyPath)) {
            valueFactory = new ReferenceValueFactory(){

                public boolean canCreateObject() {
                    return true;
                }

                public boolean canEdit() {
                    return true;
                }

                public Object createObject(Control widget, Object context) {
                    Object[] resultValue;
                    String object = null;
                    ProfileExplorerDialog dialog = new ProfileExplorerDialog(widget.getShell());
                    int result = dialog.open();
                    if (result == 0 && (resultValue = dialog.getResult()).length > 0) {
                        Object profile = resultValue[0];
                        if (profile instanceof Profile) {
                            object = ((Profile)profile).getName();
                        } else if (profile instanceof IRegisteredProfile) {
                            object = ((IRegisteredProfile)profile).getName();
                        }
                    }
                    return object;
                }

                public Object edit(Control widget, Object object) {
                    if (object instanceof String) {
                        Object[] resultValue;
                        String newValue = null;
                        ProfileExplorerDialog dialog = new ProfileExplorerDialog(widget.getShell(), (String)object);
                        int result = dialog.open();
                        if (result == 0 && (resultValue = dialog.getResult()).length > 0) {
                            Object profile = resultValue[0];
                            if (profile instanceof Profile) {
                                newValue = ((Profile)profile).getName();
                            } else if (profile instanceof IRegisteredProfile) {
                                newValue = ((IRegisteredProfile)profile).getName();
                            }
                        }
                        return newValue;
                    }
                    return null;
                }

                public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
                    return objectsToValidate;
                }
            };
        }
        return valueFactory != null ? valueFactory : super.getValueFactory(propertyPath);
    }

    public class StereotypeQualifyNameObsevableValue
    extends EMFObservableValue {
        public StereotypeQualifyNameObsevableValue(EObject eObject, EditingDomain domain) {
            super(eObject, (EStructuralFeature)ApplyStereotypeAdvicePackage.eINSTANCE.getStereotypeToApply_StereotypeQualifiedName(), domain);
        }

        protected void doSetValue(Object value) {
            CompoundCommand command = null;
            if (value instanceof String) {
                command = new CompoundCommand("set value");
                command.append(this.getSetCommand(value));
                if (StereotypeToApplyModelElement.this.source instanceof StereotypeToApply && !((String)value).isEmpty()) {
                    String stereotypeQualifiedName = ((StereotypeToApply)StereotypeToApplyModelElement.this.source).getStereotypeQualifiedName();
                    String oldProfile = "";
                    if (stereotypeQualifiedName != null && stereotypeQualifiedName.contains("::")) {
                        oldProfile = stereotypeQualifiedName.split("::")[0];
                    }
                    EList requiredProfiles = ((StereotypeToApply)StereotypeToApplyModelElement.this.source).getRequiredProfiles();
                    String profile = ((String)value).split("::")[0];
                    if (!oldProfile.equals(profile)) {
                        if (requiredProfiles.contains((Object)oldProfile)) {
                            RemoveCommand removeCommand = new RemoveCommand(StereotypeToApplyModelElement.this.getDomain(), requiredProfiles, (Object)oldProfile);
                            command.append((Command)removeCommand);
                        }
                        AddCommand addCommand = new AddCommand(StereotypeToApplyModelElement.this.getDomain(), requiredProfiles, (Object)profile);
                        command.append((Command)addCommand);
                    }
                }
            }
            this.domain.getCommandStack().execute((Command)command);
        }
    }
}

