/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;

public class RoundedRectangleUtil {
    public static PointList getLineIntersectionsWithRoundedRectangle(LineSeg line, int rectX, int rectY, int rectW, int rectH, int arcW, int arcH) {
        Point point;
        PointList intersections = new PointList();
        PointList rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + arcW / 2, rectY));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW - arcW / 2, rectY));
        PointList rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + arcW / 2, rectY + rectH));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW - arcW / 2, rectY + rectH));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX, rectY + arcH / 2));
        rect.addPoint((Point)new PrecisionPoint(rectX, rectY + rectH - arcH / 2));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW, rectY + arcH / 2));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW, rectY + rectH - arcH / 2));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        PointList ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX, rectY, arcW, arcH));
        int i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x <= rectX + arcW / 2 && point.y <= rectY + arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX + rectW - arcW, rectY, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x >= rectX + rectW - arcW / 2 && point.y <= rectY + arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX, rectY + rectH - arcH, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x <= rectX + arcW / 2 && point.y >= rectY + rectH - arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX + rectW - arcW, rectY + rectH - arcH, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x >= rectX + rectW - arcW / 2 && point.y >= rectY + rectH - arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        if (intersections.size() == 2) {
            Point point1 = intersections.getLastPoint();
            Point point2 = intersections.getFirstPoint();
            int deltaX1 = point1.x - line.getTerminus().x;
            int deltaY1 = point1.y - line.getTerminus().y;
            int deltaX2 = point2.x - line.getTerminus().x;
            int deltaY2 = point2.y - line.getTerminus().y;
            if (deltaX1 * deltaX1 + deltaY1 * deltaY1 < deltaX2 * deltaX2 + deltaY2 * deltaY2) {
                intersections.removePoint(0);
            } else {
                intersections.removePoint(1);
            }
        }
        return intersections;
    }

    public static int getPosition(Rectangle rectangle, Dimension cornerDimension, Point location) {
        int position = 0;
        Rectangle maxRect = rectangle.getCopy();
        while (maxRect.contains(location)) {
            maxRect.shrink(1, 1);
        }
        Rectangle shrinkedParent = new Rectangle(rectangle);
        shrinkedParent.shrink(cornerDimension.width / 2, cornerDimension.height / 2);
        position = location.x < shrinkedParent.getTopLeft().x && location.y < shrinkedParent.getTopLeft().y ? 9 : (location.x > shrinkedParent.getTopRight().x && location.y < shrinkedParent.getTopRight().y ? 17 : (location.x > shrinkedParent.getBottomRight().x && location.y > shrinkedParent.getBottomRight().y ? 20 : (location.x < shrinkedParent.getBottomLeft().x && location.y > shrinkedParent.getBottomLeft().y ? 12 : maxRect.getPosition(location))));
        return position;
    }
}

