/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.ConstraintsCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesContextCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesContextPluginXMLValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers.PropertiesUICustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesContextDecoratorAdapterFactory;

public class PropertiesContextPluginChecker {
    public static final String CONTEXT_EXTENSION = "ctx";
    public static final String CONTENT_TYPE = "org.eclipse.papyrus.infra.properties.context";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.properties");

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesContextPluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic");
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesContextPluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").withReferencedResources(PropertiesContextPluginChecker.createIconProvider());
    }

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(PropertiesContextPluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(PropertiesContextPluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").withReferencedResources(PropertiesContextPluginChecker.createOpaqueResourceProvider(project));
    }

    private static OpaqueResourceProvider.EMF createIconProvider() {
        return OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.ICON, (String)"http://www.eclipse.org/papyrus/properties/contexts/0.9", (EAttribute)ContextsPackage.Literals.TAB__IMAGE);
    }

    private static OpaqueResourceProvider.EMF createOpaqueResourceProvider(IProject project) {
        return PropertiesContextPluginChecker.createIconProvider();
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesContextPluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<Context, PluginErrorReporter<Context>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection contexts = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ContextsPackage.Literals.CONTEXT);
        return new ExtensionsChecker(project, modelFile, contexts, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", PropertiesContextPluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<Context> createPluginErrorReporter(IFile pluginXML, IFile modelFile, Context model) {
        PropertiesContextPluginXMLValidator validator = new PropertiesContextPluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic", context -> context.getName()).requireExtensionPoint("org.eclipse.papyrus.infra.properties.contexts", validator::matchExtension, null, validator::problemID);
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(PropertiesContextPluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.properties.diagnostic").withAdapterFactoryDecorator(PropertiesContextDecoratorAdapterFactory::new).withValidator("http://www.eclipse.org/papyrus/properties/contexts/0.9", PropertiesContextCustomValidator::new).withValidator("http://www.eclipse.org/papyrus/properties/ui/0.9", PropertiesUICustomValidator::new).withValidator("http://www.eclipse.org/papyrus/constraints/0.9", ConstraintsCustomValidator::new);
    }
}

