/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.migrate;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.gmf.internal.common.migrate.Messages;

public class ModelLoadHelper {
    private static final String DIAGNOSTIC_SOURCE = "gmf.common.modelLoadHelper";
    private IStatus status;
    private Diagnostic diagnostic;
    private URI uri;
    private ResourceSet resourceSet;

    public Resource getLoadedResource() {
        return this.resourceSet.getResource(this.uri, false);
    }

    public EObject getContentsRoot() {
        Resource resource = this.getLoadedResource();
        assert (resource != null);
        if (!resource.getContents().isEmpty()) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    public boolean isOK() {
        return this.diagnostic.getSeverity() == 0 || this.diagnostic.getSeverity() == 2;
    }

    public IStatus getStatus() {
        if (this.status == null) {
            this.status = BasicDiagnostic.toIStatus((Diagnostic)this.diagnostic);
        }
        return this.status;
    }

    public Diagnostic getDiagnostics() {
        return this.diagnostic;
    }

    static Resource.Diagnostic createDiagnostic(Resource resource, Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException("null diagnostic exception");
        }
        String location = resource.getURI() == null ? null : resource.getURI().toString();
        class ExceptionDiagnostic
        extends WrappedException
        implements Resource.Diagnostic {
            private final /* synthetic */ String val$location;

            public ExceptionDiagnostic(Exception exception, String string) {
                this.val$location = string;
                super(exception);
            }

            public String getLocation() {
                return this.val$location;
            }

            public int getColumn() {
                return 0;
            }

            public int getLine() {
                return 0;
            }
        }
        return new ExceptionDiagnostic(exception, location);
    }

    public ModelLoadHelper(ResourceSet targetResSet, URI resourceURI) {
        if (targetResSet == null || resourceURI == null) {
            throw new IllegalArgumentException("null resourceSet or resourceURI");
        }
        this.resourceSet = targetResSet;
        this.uri = resourceURI;
        this.diagnostic = ModelLoadHelper.internalLoad(targetResSet, this.uri);
    }

    private static Diagnostic internalLoad(ResourceSet resourceSet, URI uri) {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        Resource resource = resourceSet.createResource(uri, "");
        assert (resource != null);
        IOException rootException = null;
        try {
            resource.load(resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            Exception exception = rootException = e instanceof Resource.IOWrappedException ? (Exception)e.getCause() : e;
            if (!(e instanceof Resource.Diagnostic)) {
                resource.getErrors().add((Object)ModelLoadHelper.createDiagnostic(resource, rootException));
            }
        }
        catch (RuntimeException e) {
            EcorePlugin.INSTANCE.getPluginLogger().log((Object)e);
            resource.getErrors().add((Object)ModelLoadHelper.createDiagnostic(resource, e));
        }
        EList errors = resource.getErrors();
        EList warnings = resource.getWarnings();
        if (!errors.isEmpty() || !warnings.isEmpty()) {
            Object[] objectArray;
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
            Integer severityOpt = new Integer(resourceDiagnostic.getSeverity() == 4 ? 0 : 1);
            String message = MessageFormat.format(Messages.modelLoadedWithProblems, severityOpt, resource.getURI());
            if (rootException != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = rootException;
                objectArray = objectArray2;
                objectArray2[1] = resource;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = resource;
            }
            Object[] data = objectArray;
            BasicDiagnostic loadDiagnostic = new BasicDiagnostic(DIAGNOSTIC_SOURCE, resourceDiagnostic.getCode(), message, data);
            loadDiagnostic.addAll(resourceDiagnostic);
            diagnostic = loadDiagnostic;
        }
        return diagnostic;
    }
}

