/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.pluginexplorer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.papyrus.dev.pluginexplorer.Activator;
import org.eclipse.papyrus.dev.pluginexplorer.EmbeddedFile;
import org.eclipse.papyrus.dev.pluginexplorer.PhysicalFile;
import org.eclipse.papyrus.dev.pluginexplorer.PluginEntry;
import org.osgi.framework.Bundle;

public class Plugin {
    private Bundle bundle;
    private List<PluginEntry> entries;
    private File physicalLocation;

    public static Plugin[] getLoadedPlugins() {
        Bundle[] loaded = Activator.getDefault().getContext().getBundles();
        Plugin[] plugins = new Plugin[loaded.length];
        int i = 0;
        while (i != loaded.length) {
            plugins[i] = new Plugin(loaded[i]);
            ++i;
        }
        return plugins;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    public List<PluginEntry> entries() {
        return this.entries;
    }

    public String getName() {
        return this.bundle.getSymbolicName();
    }

    public Plugin(Bundle bundle) {
        this.bundle = bundle;
        this.entries = new ArrayList<PluginEntry>();
        try {
            this.physicalLocation = FileLocator.getBundleFile((Bundle)bundle);
        }
        catch (IOException e) {
            Activator.getDefault().getPapyrusLog().error("Failed to locate the plugin " + bundle.getSymbolicName(), (Throwable)e);
        }
        if (this.physicalLocation == null) {
            return;
        }
        if (this.physicalLocation.isDirectory()) {
            this.buildFromDirectory();
        } else {
            this.buildFromJar();
        }
    }

    public String getPhysicalPath() {
        if (this.physicalLocation == null) {
            return null;
        }
        return this.physicalLocation.getAbsolutePath();
    }

    public PluginEntry getEntry(String path) {
        int start = path.startsWith("/") ? 1 : 0;
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        path = path.substring(start, end);
        String[] parts = path.split("/");
        PluginEntry current = null;
        for (PluginEntry e : this.entries) {
            if (!e.getName().equals(parts[0])) continue;
            current = e;
            break;
        }
        if (current == null) {
            return null;
        }
        int i = 1;
        while (i != parts.length) {
            if ((current = current.getChild(parts[i])) == null) {
                return null;
            }
            ++i;
        }
        return current;
    }

    private void buildFromDirectory() {
        File[] content = this.physicalLocation.listFiles();
        if (content == null || content.length == 0) {
            return;
        }
        int i = 0;
        while (i != content.length) {
            this.entries.add(new PhysicalFile(this, content[i]));
            ++i;
        }
    }

    private void buildFromJar() {
        try {
            JarFile jar = new JarFile(this.physicalLocation);
            ArrayList<JarEntry> content = new ArrayList<JarEntry>();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                content.add(e.nextElement());
            }
            Collections.sort(content, new Comparator<JarEntry>(){

                @Override
                public int compare(JarEntry arg0, JarEntry arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            int next = 0;
            while (next < content.size()) {
                EmbeddedFile child = new EmbeddedFile(this, ((JarEntry)content.get(next)).getName());
                next = this.buildChildren(child, content, next + 1);
                this.entries.add(child);
            }
            jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int buildChildren(EmbeddedFile parent, List<JarEntry> content, int index) {
        if (index >= content.size()) {
            return index;
        }
        int next = index;
        while (next < content.size() && content.get(next).getName().startsWith(parent.getEntry())) {
            EmbeddedFile child = new EmbeddedFile(this, content.get(next).getName(), parent.getEntry());
            next = this.buildChildren(child, content, next + 1);
            parent.children().add(child);
        }
        return next;
    }

    InputStream getStreamInJar(String localPath) {
        try {
            final JarFile jar = new JarFile(this.physicalLocation);
            JarEntry entry = jar.getJarEntry(localPath);
            return new InputStream(entry){
                private InputStream inner;
                {
                    this.inner = jarFile.getInputStream(jarEntry);
                }

                @Override
                public int read() throws IOException {
                    return this.inner.read();
                }

                @Override
                public void close() {
                    try {
                        this.inner.close();
                        jar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (IOException e) {
            return null;
        }
    }
}

