/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractPapyrusMatcherEditor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractSinglePapyrusMatcher;

public class ObjectMatcherEditor
extends AbstractPapyrusMatcherEditor {
    public ObjectMatcherEditor(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        super(columnAccesor, columnIndex, matchOn, configRegistry);
    }

    @Override
    protected Matcher<Object> createMatcher(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        return new ObjectMatcher(columnAccesor, matchOn, columnIndex);
    }

    public static class ObjectMatcher
    extends AbstractSinglePapyrusMatcher<Object> {
        public ObjectMatcher(IColumnAccessor<Object> accessor, Object wantedObject, int columnIndex, IConfigRegistry configRegistry) {
            super(accessor, columnIndex, wantedObject, configRegistry);
        }

        public ObjectMatcher(IColumnAccessor<Object> accessor, Object wantedObject, int columnIndex) {
            super(accessor, columnIndex, wantedObject);
        }

        public boolean matches(Object item) {
            Object res = this.getColumnAccessor().getDataValue(item, this.getColumnIndex());
            if (res != null) {
                Object wantedObject = this.getObjectToMatch();
                if (res instanceof Collection) {
                    return ((Collection)res).contains(wantedObject);
                }
                if (wantedObject instanceof String) {
                    return wantedObject.equals(res);
                }
                return res == wantedObject;
            }
            return false;
        }
    }
}

