/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableUtil {
    public static List<Table> getAssociatedTables(EObject element, ResourceSet resourceSet) {
        List<Table> result;
        if (resourceSet == null) {
            resourceSet = EMFHelper.getResourceSet((EObject)element);
        }
        if (resourceSet == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<Table>(3);
            for (EStructuralFeature.Setting setting : EMFHelper.getUsages((EObject)element)) {
                if (setting.getEStructuralFeature() != NattablePackage.Literals.TABLE__OWNER || EMFHelper.getResourceSet((EObject)setting.getEObject()) != resourceSet) continue;
                result.add((Table)setting.getEObject());
            }
        }
        return result;
    }

    public static List<Table> getAssociatedTablesFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Table> tables = new LinkedList<Table>();
            for (EObject eObj : notationResource.getContents()) {
                Table table;
                if (!(eObj instanceof Table) || !element.equals((table = (Table)eObj).getOwner())) continue;
                tables.add(table);
            }
            return tables;
        }
        return Collections.emptyList();
    }

    public static ViewPrototype getPrototype(Table table) {
        PolicyChecker checker = PolicyChecker.getFor((EObject)table);
        return TableUtil.getPrototype(table, checker);
    }

    public static ViewPrototype getPrototype(Table table, boolean checkViewpoint) {
        PolicyChecker checker = PolicyChecker.getFor((EObject)table);
        return TableUtil.getPrototype(table, checker, checkViewpoint);
    }

    public static ViewPrototype getPrototype(Table table, PolicyChecker checker) {
        return TableUtil.getPrototype(table, checker, true);
    }

    public static ViewPrototype getPrototype(Table table, PolicyChecker checker, boolean checkViewpoint) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        PapyrusTable repKind = null;
        String tableKindId = table.getTableKindId();
        if (manager.getRepresentationKindById(tableKindId) != null) {
            if (manager.getRepresentationKindById(tableKindId) instanceof PapyrusTable) {
                repKind = (PapyrusTable)manager.getRepresentationKindById(tableKindId);
            } else {
                Activator.log.info("Unexpected table kind: " + tableKindId + " Your notation file might be broken or created with a previous version of the architecture framework.");
            }
            if (repKind != null) {
                if (!checkViewpoint || checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
                    return ViewPrototype.get((PapyrusRepresentationKind)repKind);
                }
                PapyrusRepresentationKind tableParentView = repKind.getParent();
                while (tableParentView != null && !checker.isInViewpoint(tableParentView)) {
                    tableParentView = tableParentView.getParent();
                }
                if (tableParentView != null) {
                    return ViewPrototype.get((PapyrusRepresentationKind)tableParentView);
                }
                String tableConfigName = repKind.getName();
                if (tableConfigName != null) {
                    for (MergedArchitectureViewpoint viewpoint : checker.getViewpoints()) {
                        for (RepresentationKind representationKind : viewpoint.getRepresentationKinds()) {
                            if (!(representationKind instanceof PapyrusRepresentationKind)) continue;
                            PapyrusRepresentationKind papyrusRepresentationKind = (PapyrusRepresentationKind)representationKind;
                            if (tableConfigName.equals(papyrusRepresentationKind.getName())) {
                                ViewPrototype.get((PapyrusRepresentationKind)papyrusRepresentationKind);
                            }
                            PapyrusRepresentationKind parentPapyrusRepresentationKind = papyrusRepresentationKind.getParent();
                            while (parentPapyrusRepresentationKind != null && !tableConfigName.equals(parentPapyrusRepresentationKind.getName())) {
                                parentPapyrusRepresentationKind = parentPapyrusRepresentationKind.getParent();
                            }
                            if (parentPapyrusRepresentationKind == null) continue;
                            return ViewPrototype.get((PapyrusRepresentationKind)papyrusRepresentationKind);
                        }
                    }
                }
            }
            return ViewPrototype.get((PolicyChecker)checker, (String)table.getTableKindId(), (EObject)table.getOwner(), (EObject)table.getContext());
        }
        return ViewPrototype.get((PolicyChecker)checker, (String)table.getTableConfiguration().getType(), (EObject)table.getOwner(), (EObject)table.getContext());
    }
}

