/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IGroupRequestAdvisor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers.GroupNotifyingOnMoveEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.editpolicy.notifiers.IGroupNotifier;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.predicates.AncestorFilter;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.predicates.DescendantsFilter;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.predicates.DescendantsFilterIGroupNotifier;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.predicates.SameContainerFilter;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.SetDeferredRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.ui.IntegrateViewToConfigureComposite;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.DebugUtils;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.Utils;
import org.eclipse.papyrus.uml.diagram.activity.commands.DeferredSetValueCommand;
import org.eclipse.papyrus.uml.diagram.activity.commands.RunNotificationCommand;
import org.eclipse.papyrus.uml.diagram.activity.edit.part.ActivityGroup.IGroupCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.common.commands.RemoveValueCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.RemoveValueRequest;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.Element;

public class GroupRequestAdvisor
implements IGroupRequestAdvisor {
    private static final String UNABLE_TO_GET_THE_INTIAL_TARGET_REQUEST_BOUNDS = "Unable to get the intial target request bounds";
    private static final String CHILDREN_REFERENCES_ARE = " ---- Children references are : ---- ";
    private static final String ALL_PARENT_REFERENCES_ARE = " ---- All parent references are : ---- ";
    private Multimap<EObject, IGroupNotifier> listenners = ArrayListMultimap.create();
    private static LogHelper log = new LogHelper((Plugin)UMLDiagramEditorPlugin.getInstance());

    public static GroupRequestAdvisor getInstance() {
        return SingletonHolder.instance;
    }

    private GroupRequestAdvisor() {
    }

    @Override
    public void addListenner(EObject eObject, IGroupNotifier editpolicy) {
        this.getListenerRegistry().put((Object)eObject, (Object)editpolicy);
    }

    @Override
    public void removeListenner(IGroupNotifier editpolicy) {
        if (editpolicy == null) {
            return;
        }
        Iterator iterator = this.getListenerRegistry().entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!editpolicy.equals(entry.getValue())) continue;
            iterator.remove();
        }
    }

    @Override
    public ICommand notifyGroupFramework(IGroupRequest request) {
        if (DebugUtils.isDebugging()) {
            log.debug("***********************BEGIN : Group Request Advisor***********************************");
        }
        CompositeCommand cc = new CompositeCommand("Global command from GroupRequestAdvisor");
        Request initialRequest = request.getInitialRequest();
        if (initialRequest instanceof ChangeBoundsRequest) {
            this.handleMove(request, cc);
        } else if (initialRequest instanceof GroupRequest && "delete".equals(initialRequest.getType())) {
            this.handleDelete(request, cc);
        }
        if (cc != null && !cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    protected void handleDelete(IGroupRequest request, CompositeCommand cc) {
    }

    protected void handleMove(IGroupRequest request, CompositeCommand cc) {
        this.fillRequestWithAllPossibleParent(request);
        this.fillRequestWithAllPossibleChildren(request);
        Object elementAdapter = request.getTargetElement().getAdapter(EObject.class);
        if (elementAdapter instanceof EObject) {
            this.handleSemanticChildren(request, cc, (EObject)elementAdapter);
            this.handleSemanticParents(request, cc, elementAdapter);
        }
        if (DebugUtils.isDebugging()) {
            log.debug("***********************END : Group Request Advisor***********************************");
        }
    }

    protected void handleSemanticChildren(IGroupRequest request, CompositeCommand cc, EObject targetElement) {
        StringBuilder stringBuilder;
        EReference eOpposite;
        EReference ref;
        List<Object> graphicalChildren = Lists.newArrayList();
        if (request.getInitialRequest() instanceof ChangeBoundsRequest) {
            graphicalChildren = this.handleGraphicalChildren(request, cc);
        }
        for (Map.Entry oldChildrenEntry : Utils.getOldChildren(request).entries()) {
            Multimap<EReference, EObject> allActualChildren = request.getChildrenEReferenceMap();
            ref = (EReference)oldChildrenEntry.getKey();
            if (ref == null || allActualChildren.containsEntry(oldChildrenEntry.getValue(), (Object)ref)) continue;
            eOpposite = ref.getEOpposite();
            if (graphicalChildren.contains(oldChildrenEntry.getValue()) || eOpposite == null || eOpposite.isContainment() || ref.isContainment()) continue;
            RemoveValueRequest rmVa = new RemoveValueRequest(targetElement, (EStructuralFeature)ref, Collections.singletonList((EObject)oldChildrenEntry.getValue()));
            RemoveValueCommand rmCmd = new RemoveValueCommand(rmVa);
            stringBuilder = new StringBuilder();
            stringBuilder.append("From handling parent : Remove ");
            stringBuilder.append(Utils.getCorrectLabel(ref));
            stringBuilder.append(" from ");
            stringBuilder.append(Utils.getCorrectLabel(targetElement));
            stringBuilder.append(" value ");
            stringBuilder.append(Utils.getCorrectLabel(oldChildrenEntry.getValue()));
            rmCmd.setLabel(stringBuilder.toString());
            if (rmCmd == null) continue;
            cc.compose((IUndoableOperation)rmCmd);
        }
        HashSet newChildren = Sets.newHashSet();
        for (Map.Entry entry : request.getChildrenEReferenceMap().entries()) {
            ref = (EReference)entry.getKey();
            if (ref != null) {
                eOpposite = ref.getEOpposite();
                if (!graphicalChildren.contains(entry.getValue())) {
                    newChildren.add((EObject)entry.getValue());
                    if (eOpposite != null && !eOpposite.isContainment()) {
                        SetDeferredRequest setRq = new SetDeferredRequest(request.getHostRequest().getEditingDomain(), request.getTargetElement(), (EStructuralFeature)ref, entry.getValue());
                        DeferredSetValueCommand setCmd = new DeferredSetValueCommand(setRq);
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("From handling parent : Set deferred");
                        stringBuilder.append(Utils.getCorrectLabel(entry.getValue()));
                        stringBuilder.append(" from ");
                        stringBuilder.append(Utils.getCorrectLabel(ref));
                        stringBuilder.append(" value ");
                        stringBuilder.append(Utils.getCorrectLabel(entry.getValue()));
                        setCmd.setLabel(stringBuilder.toString());
                        if (setCmd != null) {
                            cc.compose((IUndoableOperation)setCmd);
                        }
                    }
                }
            }
            if (newChildren.isEmpty()) continue;
            this.handleChangeParentNotificationCommand(request, cc, newChildren);
        }
    }

    protected void handleChangeParentNotificationCommand(IGroupRequest request, CompositeCommand cc, Set<EObject> newChildren) {
        final IGraphicalEditPart host = request.getHostRequest();
        Iterable listOfChidren = Iterables.transform(newChildren, (Function)new Function<EObject, IGroupNotifier>(){

            public IGroupNotifier apply(EObject arg0) {
                Collection notifiers = GroupRequestAdvisor.this.getListenerRegistry().get((Object)arg0);
                for (IGroupNotifier notifier : notifiers) {
                    IGraphicalEditPart notifierEditPart = notifier.getHostEditPart();
                    if (notifierEditPart == null || !EcoreUtil.isAncestor((EObject)host.getNotationView().getDiagram(), (EObject)notifierEditPart.getNotationView())) continue;
                    return notifier;
                }
                return null;
            }
        });
        Iterable listOfFilteredChidren = Iterables.filter((Iterable)listOfChidren, (Predicate)Predicates.notNull());
        ArrayList automaticChildren = Lists.newArrayList();
        ArrayList nonAutomaticChildren = Lists.newArrayList();
        this.dispatchChildren(request, host, listOfFilteredChidren, automaticChildren, nonAutomaticChildren);
        IGraphicalEditPart hostEditPart = request.getHostRequest();
        for (IGroupNotifier notifier : automaticChildren) {
            SetBoundsCommand setBoundCommand;
            IGraphicalEditPart notifierEditPart = notifier.getHostEditPart();
            IGraphicalEditPart hostCompartmentEditPart = request.getNodeDescpitor().getCompartmentPartFromView(hostEditPart);
            Request initialRequest = request.getInitialRequest();
            Rectangle hostBounds = null;
            hostBounds = initialRequest instanceof ChangeBoundsRequest ? Utils.getAbslotueRequestBounds((ChangeBoundsRequest)initialRequest, hostCompartmentEditPart) : Utils.getAbsoluteBounds(hostCompartmentEditPart);
            Rectangle childBounds = Utils.getAbsoluteBounds(notifierEditPart);
            MoveElementsCommand mvCmd = new MoveElementsCommand(new MoveRequest((EObject)hostCompartmentEditPart.getNotationView(), (EObject)notifierEditPart.getNotationView()));
            if (mvCmd != null && mvCmd.canExecute()) {
                cc.compose((IUndoableOperation)mvCmd);
            }
            if ((setBoundCommand = new SetBoundsCommand(WorkspaceEditingDomainFactory.INSTANCE.getEditingDomain(host.getNotationView().eResource().getResourceSet()), "test", (IAdaptable)new EObjectAdapter((EObject)notifierEditPart.getNotationView()), childBounds.translate(hostBounds.getLocation().negate()))) == null || !setBoundCommand.canExecute()) continue;
            cc.compose((IUndoableOperation)setBoundCommand);
        }
        if (!nonAutomaticChildren.isEmpty()) {
            ChangeGraphicalParentRunnable changeGraphicalParentRunnable = new ChangeGraphicalParentRunnable(host, request);
            NotificationBuilder notification = this.createChangeGraphicalParentNotification(nonAutomaticChildren, changeGraphicalParentRunnable, hostEditPart);
            RunNotificationCommand runNotifCmd = new RunNotificationCommand(request.getHostRequest().getEditingDomain(), "Notification command", GroupRequestAdvisor.getWorkspaceFiles(changeGraphicalParentRunnable.getModifiedObject()), notification);
            cc.compose((IUndoableOperation)runNotifCmd);
        }
    }

    private void dispatchChildren(IGroupRequest request, IGraphicalEditPart host, Iterable<IGroupNotifier> listOfFilteredChidren, List<IGroupNotifier> automaticChildren, List<IGroupNotifier> nonAutomaticChildren) {
        for (IGroupNotifier notifier : listOfFilteredChidren) {
            IGraphicalEditPart parentEditPart = this.getGraphicalParent(notifier.getHostEditPart());
            if (parentEditPart != null) {
                EObject eObject = parentEditPart.resolveSemanticElement();
                if (eObject instanceof ActivityGroup) {
                    ActivityGroup group = (ActivityGroup)eObject;
                    Collection groupNotifiers = this.listenners.get((Object)group);
                    if (!groupNotifiers.isEmpty()) {
                        IGroupNotifier myGroupNotifier = (IGroupNotifier)groupNotifiers.iterator().next();
                        boolean isNewContainerVisuallyIncludeInOldContainer = myGroupNotifier.includes(Utils.getAbslotueRequestBounds((ChangeBoundsRequest)request.getInitialRequest(), host));
                        boolean canTheOldContainerBeAModelParentOfTheNewContainer = myGroupNotifier.getHostGroupDescriptor().canIBeModelParentOf(host.resolveSemanticElement().eClass());
                        boolean canTheNewContainerBeModelParentOfTheOldContianer = request.getNodeDescpitor().canIBeModelParentOf(host.resolveSemanticElement().eClass());
                        IGroupNotifier currentElementNotifier = this.getIGroupNotifier(host);
                        boolean isOldContainerVisuallyIncludeInNewContainer = currentElementNotifier.includes(Utils.getAbsoluteBounds(myGroupNotifier.getHostEditPart()));
                        if (canTheOldContainerBeAModelParentOfTheNewContainer && isNewContainerVisuallyIncludeInOldContainer) {
                            automaticChildren.add(notifier);
                            continue;
                        }
                        if (canTheNewContainerBeModelParentOfTheOldContianer && isOldContainerVisuallyIncludeInNewContainer) continue;
                        if (currentElementNotifier.getHostGroupDescriptor().getContainmentReferenceFor(notifier.getHostEditPart().resolveSemanticElement().eClass()) == null) {
                            nonAutomaticChildren.add(notifier);
                            continue;
                        }
                        automaticChildren.add(notifier);
                        continue;
                    }
                    nonAutomaticChildren.add(notifier);
                    continue;
                }
                if (parentEditPart.equals(host)) continue;
                automaticChildren.add(notifier);
                continue;
            }
            DebugUtils.getLog().error("Unable to retreive graphical parent of " + Utils.getCorrectLabel(notifier), null);
        }
    }

    private IGroupNotifier getIGroupNotifier(IGraphicalEditPart host) {
        EditPolicy editPolicy = host.getEditPolicy((Object)"GroupFramework_NotifyingOnMoveEditPolicy");
        if (editPolicy instanceof IGroupNotifier) {
            return (IGroupNotifier)editPolicy;
        }
        editPolicy = host.getEditPolicy((Object)"GroupFramework_NotifyingOnCreationEditPolicy");
        if (editPolicy instanceof IGroupNotifier) {
            return (IGroupNotifier)editPolicy;
        }
        throw new RuntimeException("Unable to retreive the IGroupNofier of the current group");
    }

    private IGraphicalEditPart getGraphicalParent(IGraphicalEditPart child) {
        IGraphicalEditPart result = child;
        EObject childElement = child.resolveSemanticElement();
        if (child != null) {
            while (childElement == result.resolveSemanticElement()) {
                try {
                    result = (IGraphicalEditPart)result.getParent();
                }
                catch (ClassCastException e) {
                    return result;
                }
            }
        }
        return result;
    }

    private NotificationBuilder createChangeGraphicalParentNotification(final Iterable<IGroupNotifier> listOfFilteredChidren, ChangeGraphicalParentRunnable changeGraphicalParentRunnable, final IGraphicalEditPart host) {
        return new NotificationBuilder().setType(Type.INFO).setAsynchronous(true).setTemporary(true).setDelay(3000L).setTitle("Papyrus graphical modification").setComposite(new ICompositeCreator(){

            public Composite createComposite(Composite parent, FormToolkit toolkit) {
                return new IntegrateViewToConfigureComposite(parent, 0, Lists.newArrayList((Iterable)Lists.newArrayList((Iterable)listOfFilteredChidren)), "New elements are visually contained in the current group (" + Utils.getCorrectLabel((IAdaptable)host) + ").\n Please select the elements you want to integrate into this group figure.");
            }
        }).addAction((NotificationRunnable)changeGraphicalParentRunnable);
    }

    protected List<EObject> handleGraphicalChildren(IGroupRequest request, CompositeCommand cc) {
        IContainerNodeDescriptor nodeDescpitor;
        ArrayList<EObject> graphicalChildren = new ArrayList<EObject>();
        Object targetEditPart = request.getTargetElement().getAdapter(IGraphicalEditPart.class);
        IGraphicalEditPart compartementEditPart = null;
        if (targetEditPart instanceof IGroupCompartmentEditPart) {
            compartementEditPart = (IGraphicalEditPart)targetEditPart;
        } else if (targetEditPart instanceof IGraphicalEditPart && (nodeDescpitor = request.getNodeDescpitor()) != null) {
            compartementEditPart = nodeDescpitor.getCompartmentPartFromView((IGraphicalEditPart)targetEditPart);
        }
        if (compartementEditPart != null) {
            Iterable policies = Iterables.transform((Iterable)compartementEditPart.getChildren(), (Function)new Function<IGraphicalEditPart, GroupNotifyingOnMoveEditPolicy>(){

                public GroupNotifyingOnMoveEditPolicy apply(IGraphicalEditPart from) {
                    EditPolicy editPolicy = from.getEditPolicy((Object)"GroupFramework_NotifyingOnMoveEditPolicy");
                    if (editPolicy instanceof GroupNotifyingOnMoveEditPolicy) {
                        return (GroupNotifyingOnMoveEditPolicy)editPolicy;
                    }
                    return null;
                }
            });
            for (GroupNotifyingOnMoveEditPolicy p : policies) {
                if (p == null) continue;
                if (DebugUtils.isDebugging()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("+++ Work for child ");
                    stringBuilder.append(Utils.getCorrectLabel(p.getEObject()));
                    stringBuilder.append(" +++");
                    DebugUtils.getLog().debug(stringBuilder.toString());
                }
                Request initialRequest = request.getInitialRequest();
                Object auxChReq = null;
                auxChReq = initialRequest instanceof ChangeBoundsRequest ? Utils.getChangeBoundsRequestCopy((ChangeBoundsRequest)initialRequest, (EditPart)p.getHostEditPart()) : initialRequest;
                graphicalChildren.add(p.getEObject());
                org.eclipse.gef.commands.Command childCommand = p.getCommand((Request)auxChReq);
                if (childCommand == null || !childCommand.canExecute()) continue;
                cc.compose((IUndoableOperation)new CommandProxy(childCommand));
            }
        }
        return graphicalChildren;
    }

    protected void handleSemanticParents(IGroupRequest request, CompositeCommand cc, Object elementAdapter) {
        StringBuilder stringBuilder;
        EReference eOpposite;
        EReference ref;
        EObject targetElement = (EObject)elementAdapter;
        Multimap<EReference, EObject> allActualParent = request.getParentEReferenceMap();
        for (Map.Entry entry : Utils.getOldParents(request).entries()) {
            ref = (EReference)entry.getKey();
            if (ref == null || allActualParent.containsEntry((Object)ref, entry.getValue()) || (eOpposite = ref.getEOpposite()) == null || eOpposite.isContainment() || eOpposite.isDerived()) continue;
            RemoveValueRequest rmVa = new RemoveValueRequest(targetElement, (EStructuralFeature)ref, Collections.singletonList((EObject)entry.getValue()));
            RemoveValueCommand rmCmd = new RemoveValueCommand(rmVa);
            stringBuilder = new StringBuilder();
            stringBuilder.append("From handling parent : Remove ");
            stringBuilder.append(Utils.getCorrectLabel(entry.getValue()));
            stringBuilder.append(" from ");
            stringBuilder.append(Utils.getCorrectLabel(targetElement));
            stringBuilder.append(" value ");
            stringBuilder.append(Utils.getCorrectLabel(entry.getValue()));
            rmCmd.setLabel(stringBuilder.toString());
            if (rmCmd == null) continue;
            cc.compose((IUndoableOperation)rmCmd);
        }
        for (Map.Entry entry : request.getParentEReferenceMap().entries()) {
            ref = (EReference)entry.getKey();
            if (ref == null || (eOpposite = ref.getEOpposite()) == null || eOpposite.isContainment() || ref.isContainment()) continue;
            SetDeferredRequest setRq = new SetDeferredRequest(request.getHostRequest().getEditingDomain(), request.getTargetElement(), (EStructuralFeature)ref, entry.getValue());
            DeferredSetValueCommand setCmd = new DeferredSetValueCommand(setRq);
            stringBuilder = new StringBuilder();
            stringBuilder.append("From handling parent : Set deferred ");
            stringBuilder.append(Utils.getCorrectLabel(ref));
            stringBuilder.append(" from ");
            stringBuilder.append(Utils.getCorrectLabel(request.getTargetElement()));
            stringBuilder.append(" value ");
            stringBuilder.append(Utils.getCorrectLabel(entry.getValue()));
            setCmd.setLabel(stringBuilder.toString());
            if (setCmd == null) continue;
            cc.compose((IUndoableOperation)setCmd);
        }
    }

    protected Multimap<EReference, IGroupNotifier> fillRequestWithAllPossibleChildren(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> result = this.fillReqestWithReferendedElement(request, false, false);
        DebugUtils.displayMultipmapDebug(CHILDREN_REFERENCES_ARE, request.getChildrenEReferenceMap());
        return result;
    }

    public EObject getPossibleModelParent(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> parentsMap = this.fillReqestWithReferendedElement(request, true, true);
        ArrayList parents = Lists.newArrayList((Iterable)parentsMap.values());
        Collections.sort(parents);
        if (!parents.isEmpty()) {
            return ((IGroupNotifier)parents.get(0)).getEObject();
        }
        return request.getHostRequest().resolveSemanticElement();
    }

    protected void getReferenceElements(IGroupRequest request, Rectangle newBounds, List<EReference> references, Multimap<EReference, Element> eReferenceMapToFillInRequest, Multimap<EReference, IGroupNotifier> result, boolean include, boolean containementOnly, Map<EStructuralFeature, EStructuralFeature> parentOpositeFeature) {
        Iterable activeListeners = Iterables.filter((Iterable)this.getListenerRegistry().values(), (Predicate)new ActiveListener(this.getCurrentlyDisplayedDiagram(request)));
        for (IGroupNotifier input : activeListeners) {
            Object adapter;
            EObject inputEObject = input.getEObject();
            if (inputEObject == null || !(inputEObject instanceof Element) || inputEObject.equals(adapter = request.getTargetElement().getAdapter(EObject.class))) continue;
            EReference refenceFounded = null;
            for (EReference ref : references) {
                EClass eoBjectType;
                EClass refType = ref.getEReferenceType();
                if (!refType.isSuperTypeOf(eoBjectType = inputEObject.eClass())) continue;
                refenceFounded = ref;
                break;
            }
            if (refenceFounded == null || (!include || !input.includes(newBounds)) && (include || !input.isIncludedIn(newBounds)) || containementOnly && parentOpositeFeature.get(refenceFounded) instanceof EReference && !((EReference)parentOpositeFeature.get(refenceFounded)).isContainment()) continue;
            eReferenceMapToFillInRequest.put(refenceFounded, (Object)((Element)inputEObject));
            result.put((Object)refenceFounded, (Object)input);
        }
    }

    protected Diagram getCurrentlyDisplayedDiagram(IGroupRequest request) {
        Object m;
        IGraphicalEditPart graph = request.getHostRequest();
        if (graph != null && (m = graph.getModel()) instanceof View) {
            View v = (View)m;
            return v.getDiagram();
        }
        throw new RuntimeException("Unable to get the current diagram displayed");
    }

    protected Multimap<EReference, IGroupNotifier> fillRequestWithAllPossibleParent(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> result = this.fillReqestWithReferendedElement(request, true, false);
        DebugUtils.displayMultipmapDebug(ALL_PARENT_REFERENCES_ARE, request.getParentEReferenceMap());
        return result;
    }

    protected Multimap<EReference, IGroupNotifier> fillReqestWithReferendedElement(IGroupRequest request, boolean lookingForParent, boolean onlyContainment) {
        Rectangle newBounds = GroupRequestAdvisor.getInitalTargetRequestNewBounds(request);
        ArrayListMultimap result = ArrayListMultimap.create();
        if (request.getNodeDescpitor() == null) {
            return result;
        }
        List<EReference> references = null;
        references = lookingForParent ? request.getNodeDescpitor().getParentReferences() : request.getNodeDescpitor().getChildrenReferences();
        ArrayListMultimap auxResult = ArrayListMultimap.create();
        ArrayListMultimap eReferenceLookedForMap = ArrayListMultimap.create();
        this.getReferenceElements(request, newBounds, references, (Multimap<EReference, Element>)eReferenceLookedForMap, (Multimap<EReference, IGroupNotifier>)auxResult, lookingForParent, onlyContainment, lookingForParent ? request.getNodeDescpitor().getParentEOppositeReferences() : null);
        for (EReference ref : eReferenceLookedForMap.keySet()) {
            Object adapter = request.getTargetElement().getAdapter(EObject.class);
            if (!(adapter instanceof Element)) continue;
            Element element = (Element)adapter;
            Predicate composedPredicate = Predicates.and((Predicate)new SameContainerFilter(element), (Predicate)(lookingForParent ? new DescendantsFilter(eReferenceLookedForMap.values()) : new AncestorFilter(eReferenceLookedForMap.values())));
            Collection filteredCollection = Collections2.filter((Collection)eReferenceLookedForMap.get((Object)ref), (Predicate)composedPredicate);
            if (lookingForParent) {
                request.getParentEReferenceMap().putAll((Object)ref, (Iterable)filteredCollection);
                continue;
            }
            request.getChildrenEReferenceMap().putAll((Object)ref, (Iterable)filteredCollection);
        }
        for (EReference ref : auxResult.keySet()) {
            Iterable resultCollection = Iterables.filter((Iterable)auxResult.get((Object)ref), (Predicate)new DescendantsFilterIGroupNotifier(auxResult.values()));
            result.putAll((Object)ref, resultCollection);
        }
        return result;
    }

    public static Rectangle getInitalTargetRequestNewBounds(IGroupRequest request) {
        Request initialRequest = request.getInitialRequest();
        if (initialRequest instanceof ChangeBoundsRequest) {
            return Utils.getAbslotueRequestBounds((ChangeBoundsRequest)initialRequest, request.getHostRequest());
        }
        if (initialRequest instanceof CreateViewRequest) {
            return Utils.getAbslotueRequestBounds((CreateViewRequest)initialRequest);
        }
        throw new RuntimeException(UNABLE_TO_GET_THE_INTIAL_TARGET_REQUEST_BOUNDS);
    }

    protected static List getWorkspaceFiles(EObject eObject) {
        IFile file;
        Resource resource;
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (eObject != null && (resource = eObject.eResource()) != null && (file = WorkspaceSynchronizer.getFile((Resource)resource)) != null) {
            result.add(file);
        }
        return result;
    }

    protected static List getWorkspaceFiles(List eObjects) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (Object next : eObjects) {
            IFile file;
            Resource resource;
            if (!(next instanceof EObject) || (resource = ((EObject)next).eResource()) == null || (file = WorkspaceSynchronizer.getFile((Resource)resource)) == null) continue;
            result.add(file);
        }
        return result;
    }

    @Override
    public Multimap<EObject, IGroupNotifier> getListenerRegistry() {
        return this.listenners;
    }

    /* synthetic */ GroupRequestAdvisor(GroupRequestAdvisor groupRequestAdvisor) {
        this();
    }

    private static class ActiveListener
    implements Predicate<IGroupNotifier> {
        private Diagram currentDiagramDisplayed;

        public ActiveListener(Diagram currentDiagramDisplayed) {
            this.currentDiagramDisplayed = currentDiagramDisplayed;
            Assert.isNotNull((Object)currentDiagramDisplayed);
        }

        public boolean apply(IGroupNotifier input) {
            View primaryView;
            IGraphicalEditPart host = input.getHostEditPart();
            if (host != null && (primaryView = host.getPrimaryView()) != null) {
                return this.currentDiagramDisplayed.equals(primaryView.getDiagram());
            }
            return false;
        }
    }

    private final class ChangeGraphicalParentRunnable
    implements NotificationRunnable {
        private final IGraphicalEditPart host;
        private final IGroupRequest request;
        private List<View> viewTomodify;

        private ChangeGraphicalParentRunnable(IGraphicalEditPart host, IGroupRequest request) {
            this.host = host;
            this.request = request;
        }

        public void run(IContext context) {
            IntegrateViewToConfigureComposite composite = (IntegrateViewToConfigureComposite)((Object)context.get("composite_created_please_check_IContext_Constant"));
            INotification notif = (INotification)context.get("notification_object_please_check_IContext_Constant");
            CompositeTransactionalCommand ccMovingElement = new CompositeTransactionalCommand(this.request.getHostRequest().getEditingDomain(), "Move graphical elements into a new host");
            this.viewTomodify = Lists.newArrayList();
            IGraphicalEditPart hostEditPart = this.request.getHostRequest();
            this.viewTomodify.add(this.host.getNotationView());
            for (IGroupNotifier notifier : composite.getSelectedNotifier()) {
                EObject semanticElementToDrop;
                IGraphicalEditPart notifierEditPart = notifier.getHostEditPart();
                IGraphicalEditPart hostCompartmentEditPart = this.request.getNodeDescpitor().getCompartmentPartFromView(hostEditPart);
                if (DebugUtils.isDebugging()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Move ");
                    stringBuilder.append(Utils.getCorrectLabel((IAdaptable)notifierEditPart));
                    stringBuilder.append(" to ");
                    stringBuilder.append(Utils.getCorrectLabel((IAdaptable)hostEditPart));
                    DebugUtils.getLog().info(stringBuilder.toString());
                }
                if (notifierEditPart == null || (semanticElementToDrop = notifierEditPart.resolveSemanticElement()) == null || hostCompartmentEditPart == null) continue;
                ChangeBoundsRequest chdBoundsRequest = new ChangeBoundsRequest((Object)"add children");
                chdBoundsRequest.setEditParts((EditPart)notifierEditPart);
                this.viewTomodify.add(notifierEditPart.getNotationView());
                org.eclipse.gef.commands.Command dropcommand = hostCompartmentEditPart.getCommand((Request)chdBoundsRequest);
                if (dropcommand == null) continue;
                ccMovingElement.compose((IUndoableOperation)new CommandProxy(dropcommand));
            }
            if (ccMovingElement != null && !ccMovingElement.isEmpty()) {
                this.host.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)ccMovingElement));
            }
            notif.delete();
        }

        public String getLabel() {
            return "OK";
        }

        public List getModifiedObject() {
            return this.viewTomodify == null ? Collections.emptyList() : this.viewTomodify;
        }
    }

    private static class SingletonHolder {
        public static final GroupRequestAdvisor instance = new GroupRequestAdvisor(null);

        private SingletonHolder() {
        }
    }
}

