/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.anchors.ConnectionSourceAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.anchors.ConnectionTargetAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.MessageLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.MessageDelete;
import org.eclipse.papyrus.uml.diagram.sequence.figures.MessageFigure;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.IKeyPressState;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.KeyboardListener;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ConnectMessageToGridEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ConnectRectangleToGridEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.LifeLineGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.GeneralOrderingUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SelectMessagesEditPartTracker;
import org.eclipse.papyrus.uml.diagram.sequence.util.SelfMessageHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMessageEditPart
extends UMLConnectionNodeEditPart
implements IKeyPressState {
    private boolean reorderMessages = false;
    protected KeyboardListener SHIFTDown = new KeyboardListener(this, 131072, true);
    protected KeyboardListener SHIFTUp = new KeyboardListener(this, 131072, false);
    private MouseMoveListener mouseMoveListener;
    private Cursor myCursor;
    private Cursor defaultCursor;

    public AbstractMessageEditPart(View view) {
        super(view);
    }

    @Override
    public void setKeyPressState(Boolean isPressed) {
        this.reorderMessages = isPressed;
    }

    public boolean mustReorderMessage() {
        if (this.getFigure() instanceof MessageDelete) {
            return false;
        }
        return this.reorderMessages;
    }

    public void activate() {
        super.activate();
        PlatformUI.getWorkbench().getDisplay().addFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().addFilter(2, (Listener)this.SHIFTUp);
        if (this.getTarget() == null || this.getSource() == null) {
            this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractMessageEditPart.this.hookGraphicalViewer();
                }
            });
        } else {
            this.hookGraphicalViewer();
        }
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectMessagesEditPartTracker((org.eclipse.gef.ConnectionEditPart)this);
    }

    private void hookGraphicalViewer() {
        if (SelfMessageHelper.isSelfLink(this)) {
            this.mouseMoveListener = new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    AbstractMessageEditPart.this.handleMouseMoved(e.x, e.y);
                }
            };
            this.getViewer().getControl().addMouseMoveListener(this.mouseMoveListener);
        }
    }

    protected void handleMouseMoved(int x, int y) {
        this.myCursor = null;
        if (this.defaultCursor != null) {
            this.getViewer().setCursor(Cursors.ARROW);
            this.defaultCursor = null;
        }
        if (!SelfMessageHelper.isSelfLink(this)) {
            return;
        }
        MessageFigure primaryShape = this.getPrimaryShape();
        Point p = new Point(x, y);
        primaryShape.translateToRelative((Translatable)p);
        if (!primaryShape.containsPoint(p.x, p.y)) {
            return;
        }
        PointList points = primaryShape.getPoints();
        if (points.size() <= 1) {
            return;
        }
        List lineSegments = PointListUtilities.getLineSegments((PointList)points);
        LineSeg nearestSegment = PointListUtilities.getNearestSegment((List)lineSegments, (int)p.x, (int)p.y);
        this.myCursor = points.size() > 3 && (p.getDistance(points.getPoint(1)) < 5.0 || p.getDistance(points.getPoint(2)) < 5.0) ? Cursors.SIZEALL : (nearestSegment.isHorizontal() ? Cursors.SIZENS : Cursors.SIZEWE);
        this.defaultCursor = this.getViewer().getControl().getCursor();
        this.getViewer().setCursor(this.myCursor);
        if (SelfMessageHelper.isSelfLink(this)) {
            this.getPrimaryShape().setCustomCursor(this.myCursor);
        } else {
            this.getPrimaryShape().setCustomCursor(null);
        }
    }

    public abstract MessageFigure getPrimaryShape();

    public void deactivate() {
        if (this.mouseMoveListener != null) {
            this.getViewer().getControl().removeMouseMoveListener(this.mouseMoveListener);
        }
        PlatformUI.getWorkbench().getDisplay().removeFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().removeFilter(2, (Listener)this.SHIFTUp);
        super.deactivate();
    }

    private Cursor getCustomCursor() {
        if (!SelfMessageHelper.isSelfLink(this)) {
            return null;
        }
        return this.myCursor;
    }

    protected int getLineWidth() {
        int lineWidth = super.getLineWidth();
        return lineWidth < 0 ? 1 : lineWidth;
    }

    protected void fireSelectionChanged() {
        super.fireSelectionChanged();
        MessageFigure primaryShape = this.getPrimaryShape();
        if (primaryShape instanceof MessageFigure) {
            primaryShape.setSelection(this.getSelected() != 0);
        }
    }

    public View findChildByModel(EObject model) {
        List list = this.getModelChildren();
        if (list != null && list.size() > 0) {
            for (Object o : list) {
                View view;
                if (!(o instanceof View) || (view = (View)o).getElement() != model) continue;
                return view;
            }
        }
        return null;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("MaskManagedLabelPolicy", (EditPolicy)new MessageLabelEditPolicy());
        this.installEditPolicy(ConnectRectangleToGridEditPolicy.CONNECT_TO_GRILLING_MANAGEMENT, (EditPolicy)new ConnectMessageToGridEditPolicy());
        this.installEditPolicy("SEQUENCE_REFERENCE", (EditPolicy)new SequenceReferenceEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new MessageGraphicalNodeEditPolicy());
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            List types = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes();
            if (types.contains(UMLElementTypes.Message_FoundEdge) || types.contains(UMLElementTypes.Message_LostEdge)) {
                return null;
            }
        } else if (request instanceof ReconnectRequest) {
            org.eclipse.gef.ConnectionEditPart con = ((ReconnectRequest)request).getConnectionEditPart();
            if (con instanceof MessageLostEditPart || con instanceof MessageFoundEditPart) {
                return null;
            }
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            if (DurationLinkUtil.isDurationLink(reconnectRequest) || GeneralOrderingUtil.isGeneralOrderingLink(reconnectRequest)) {
                return this.doGetTargetEditPart(reconnectRequest);
            }
        }
        return super.getTargetEditPart(request);
    }

    protected EditPart doGetTargetEditPart(ReconnectRequest reconnectRequest) {
        if ("applyStereotype".equals(reconnectRequest.getType())) {
            return this;
        }
        AbstractEditPart.EditPolicyIterator i = this.getEditPolicyIterator();
        EditPart targetEditPart = null;
        while (i.hasNext()) {
            targetEditPart = i.next().getTargetEditPart((Request)reconnectRequest);
            if (targetEditPart != null) break;
        }
        if (reconnectRequest.isMovingStartAnchor() ? reconnectRequest.getConnectionEditPart().getSource() == targetEditPart : reconnectRequest.getConnectionEditPart().getTarget() == targetEditPart) {
            return targetEditPart;
        }
        if (this.isCyclicConnectionRequest((org.eclipse.gef.ConnectionEditPart)targetEditPart, reconnectRequest.getConnectionEditPart(), false, reconnectRequest.isMovingStartAnchor())) {
            return null;
        }
        return targetEditPart;
    }

    private boolean isCyclicConnectionRequest(org.eclipse.gef.ConnectionEditPart targetCEP, org.eclipse.gef.ConnectionEditPart sourceCEP, boolean checkSourceAndTargetEditParts, boolean doNotCheckSourceEditPart) {
        if (targetCEP == null || sourceCEP == null) {
            return false;
        }
        HashSet<IFigure> set = new HashSet<IFigure>();
        this.getSourceAndTargetConnections(set, sourceCEP);
        if (set.contains(targetCEP.getFigure())) {
            return true;
        }
        EditPart sourceEP = sourceCEP.getSource();
        EditPart targetEP = sourceCEP.getTarget();
        if ((checkSourceAndTargetEditParts || !doNotCheckSourceEditPart) && sourceEP instanceof org.eclipse.gef.ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (org.eclipse.gef.ConnectionEditPart)sourceEP, true, doNotCheckSourceEditPart)) {
            return true;
        }
        return (checkSourceAndTargetEditParts || doNotCheckSourceEditPart) && targetEP instanceof org.eclipse.gef.ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (org.eclipse.gef.ConnectionEditPart)targetEP, true, doNotCheckSourceEditPart);
    }

    private void getSourceAndTargetConnections(Set<IFigure> set, org.eclipse.gef.ConnectionEditPart connectionEditPart) {
        if (connectionEditPart == null || set == null) {
            return;
        }
        for (org.eclipse.gef.ConnectionEditPart next : connectionEditPart.getSourceConnections()) {
            Connection sourceConnection = (Connection)next.getFigure();
            set.add((IFigure)sourceConnection);
            this.getSourceAndTargetConnections(set, next);
        }
        for (org.eclipse.gef.ConnectionEditPart next : connectionEditPart.getTargetConnections()) {
            Connection targetConnection = (Connection)next.getFigure();
            set.add((IFigure)targetConnection);
            this.getSourceAndTargetConnections(set, next);
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        MessageLabelEditPart labelPart = this.getMessageLabelEditPart();
        if (labelPart == null) {
            return;
        }
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            labelPart.refreshFontColor();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            labelPart.refreshFont();
        }
    }

    public MessageLabelEditPart getMessageLabelEditPart() {
        for (Object c : this.getChildren()) {
            if (!(c instanceof MessageLabelEditPart)) continue;
            return (MessageLabelEditPart)((Object)c);
        }
        return null;
    }

    public void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof MessageFigure) {
            MessageFigure edge = this.getPrimaryShape();
            edge.setLineWidth(width < 0 ? 1 : width);
        }
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().showSourceFeedback(request);
            this.getTarget().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getSource().eraseSourceFeedback(request);
            this.getTarget().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    protected void installRouter() {
        this.getConnectionFigure().setConnectionRouter(LifeLineGraphicalNodeEditPolicy.messageRouter);
        this.getConnectionFigure().setCursor(org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors.CURSOR_SEG_MOVE);
        this.refreshBendpoints();
    }

    protected void refreshRoutingStyles() {
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object type : relationshipTypes) {
                if (!UMLElementTypes.DurationConstraint_Edge.equals(type) && !UMLElementTypes.DurationObservation_Edge.equals(type) && !UMLElementTypes.GeneralOrdering_Edge.equals(type)) continue;
                return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), createRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            if (DurationLinkUtil.isDurationLink(createRequest) || GeneralOrderingUtil.isGeneralOrderingLink(createRequest)) {
                return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), createRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
            }
        } else if (request instanceof ReconnectRequest && (DurationLinkUtil.isDurationLink(reconnectRequest = (ReconnectRequest)request) || GeneralOrderingUtil.isGeneralOrderingLink(reconnectRequest))) {
            return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), reconnectRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object type : relationshipTypes) {
                if (!UMLElementTypes.DurationConstraint_Edge.equals(type) && !UMLElementTypes.DurationObservation_Edge.equals(type) && !UMLElementTypes.GeneralOrdering_Edge.equals(type)) continue;
                return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), createRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            if (DurationLinkUtil.isDurationLink(createRequest) || GeneralOrderingUtil.isGeneralOrderingLink(createRequest)) {
                return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), createRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
            }
        } else if (request instanceof ReconnectRequest && (DurationLinkUtil.isDurationLink(reconnectRequest = (ReconnectRequest)request) || GeneralOrderingUtil.isGeneralOrderingLink(reconnectRequest))) {
            return OccurrenceSpecificationUtil.isSource((IFigure)this.getConnectionFigure(), reconnectRequest.getLocation()) ? new ConnectionSourceAnchor((PolylineConnection)this.getPrimaryShape()) : new ConnectionTargetAnchor((PolylineConnection)this.getPrimaryShape());
        }
        return super.getTargetConnectionAnchor(request);
    }

    static abstract class MessageLabelEditPart
    extends LabelEditPart {
        public MessageLabelEditPart(View view) {
            super(view);
        }

        protected void handleNotificationEvent(Notification notification) {
            Object feature = notification.getFeature();
            if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(feature)) {
                this.refreshFontColor();
            } else {
                super.handleNotificationEvent(notification);
            }
        }

        public void refreshFontColor() {
            FontStyle style = (FontStyle)((ConnectionEditPart)this.getParent()).getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
            if (style != null) {
                this.setFontColor(DiagramColorRegistry.getInstance().getColor(Integer.valueOf(style.getFontColor())));
            }
        }

        protected void refreshFont() {
            super.refreshFont();
        }
    }
}

