/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.primitives.Primitives;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.WrappedException;

public class Duck {
    private final Object target;

    public Duck(Object target) {
        if (target == null) {
            throw new NullPointerException();
        }
        this.target = target;
    }

    public boolean understands(String methodName, Object ... arg) {
        return this.lookup(methodName, null, arg) != null;
    }

    public boolean understandsp(String methodPattern, Object ... arg) {
        return this.lookup(Pattern.compile(methodPattern), null, arg) != null;
    }

    public <T> T quack(String methodName, Object ... arg) {
        return this.invoke(this.lookup(methodName, null, arg), arg);
    }

    public <T> T quackp(String methodPattern, Object ... arg) {
        return this.invoke(this.lookup(Pattern.compile(methodPattern), null, arg), arg);
    }

    public <T> T quack(String methodName, Class<T> returning, Object ... arg) {
        return this.invoke(this.lookup(methodName, returning, arg), arg);
    }

    public <T> T quackp(String methodPattern, Class<T> returning, Object ... arg) {
        return this.invoke(this.lookup(Pattern.compile(methodPattern), returning, arg), arg);
    }

    private <T> T invoke(Method method, Object[] args) {
        try {
            return (T)(method == null ? null : method.invoke(this.target, args));
        }
        catch (IllegalAccessException e) {
            throw new WrappedException((Exception)e);
        }
        catch (InvocationTargetException e) {
            Throwable toThrow = e.getTargetException();
            if (toThrow instanceof Error) {
                throw (Error)toThrow;
            }
            throw new WrappedException((Exception)toThrow);
        }
    }

    private Method lookup(String methodName, Class<?> returning, Object[] args) {
        Method result = null;
        Class<?>[] signature = Duck.signature(args);
        Method[] scope = this.target.getClass().getMethods();
        int i = 0;
        while (result == null && i < scope.length) {
            Method next = scope[i];
            if (next.getName().equals(methodName) && Duck.matchReturn(next.getReturnType(), returning) && Duck.match(next, signature)) {
                result = next;
            }
            ++i;
        }
        return result;
    }

    private Method lookup(Pattern methodPattern, Class<?> returning, Object[] args) {
        Matcher m = methodPattern.matcher("");
        Method result = null;
        Class<?>[] signature = Duck.signature(args);
        Method[] scope = this.target.getClass().getMethods();
        int i = 0;
        while (result == null && i < scope.length) {
            Method next = scope[i];
            m.reset(next.getName());
            if (m.matches() && Duck.matchReturn(next.getReturnType(), returning) && Duck.match(next, signature)) {
                result = next;
            }
            ++i;
        }
        return result;
    }

    private static boolean match(Method method, Class<?>[] signature) {
        boolean result;
        Class<?>[] params = method.getParameterTypes();
        boolean bl = result = params.length == signature.length;
        if (result) {
            int i = 0;
            while (result && i < signature.length) {
                result = Duck.matchParameter(params[i], signature[i]);
                ++i;
            }
        }
        return result;
    }

    private static boolean matchReturn(Class<?> returnType, Class<?> expectedType) {
        boolean result = expectedType == null ? true : (returnType == Void.TYPE || returnType == Void.class ? expectedType == Void.TYPE || expectedType == Void.class : Primitives.unwrap(expectedType).isAssignableFrom(Primitives.unwrap(returnType)));
        return result;
    }

    private static boolean matchParameter(Class<?> paramType, Class<?> argType) {
        boolean result = argType == Void.class ? !paramType.isPrimitive() : (paramType.isPrimitive() ? Primitives.wrap(paramType).isAssignableFrom(argType) : paramType.isAssignableFrom(argType));
        return result;
    }

    private static Class<?>[] signature(Object[] args) {
        Class[] result = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            result[i] = args[i] == null ? Void.class : args[i].getClass();
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Duck && this.target.equals(((Duck)obj).target);
    }

    public int hashCode() {
        return this.target.hashCode();
    }
}

