/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import java.util.List;

public final class MouseOnlySortingStrategy
implements SortingStrategy {
    private final boolean multipleColumnSort;

    public MouseOnlySortingStrategy(boolean multipleColumnSort) {
        this.multipleColumnSort = multipleColumnSort;
    }

    public void columnClicked(SortingState sortingState, int column, int clicks, boolean shift, boolean control) {
        SortingState.SortingColumn clickedColumn = sortingState.getColumns().get(column);
        if (clickedColumn.getComparators().isEmpty()) {
            return;
        }
        List<SortingState.SortingColumn> recentlyClickedColumns = sortingState.getRecentlyClickedColumns();
        if (clicks == 2) {
            for (SortingState.SortingColumn sortingColumn : recentlyClickedColumns) {
                sortingColumn.clear();
            }
            recentlyClickedColumns.clear();
        } else if (!this.multipleColumnSort) {
            for (SortingState.SortingColumn sortingColumn : recentlyClickedColumns) {
                if (sortingColumn == clickedColumn) continue;
                sortingColumn.clear();
            }
            recentlyClickedColumns.clear();
        }
        int netClicks = 1 + clickedColumn.getComparatorIndex() * 2 + (clickedColumn.isReverse() ? 1 : 0);
        clickedColumn.setComparatorIndex(netClicks / 2 % clickedColumn.getComparators().size());
        clickedColumn.setReverse(netClicks % 2 == 1);
        if (!recentlyClickedColumns.contains(clickedColumn)) {
            recentlyClickedColumns.add(clickedColumn);
        }
        sortingState.fireSortingChanged();
    }
}

