/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class LinkEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private impl.diagram.editparts.LinkEditPart xptLinkEditPart;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  public CharSequence qualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.xptLinkEditPart.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.xptLinkEditPart.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("package ");
    CharSequence _packageName = this.xptLinkEditPart.packageName(it);
    _builder.append(_packageName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public class ");
    CharSequence _className = this.xptLinkEditPart.className(it);
    _builder.append(_className, "\t");
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList, "\t");
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList, "\t");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _constructor = this.xptLinkEditPart.constructor(it);
    _builder.append(_constructor, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _addFixedChild = this.xptLinkEditPart.addFixedChild(it);
    _builder.append(_addFixedChild, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _addChildVisual = this.xptLinkEditPart.addChildVisual(it);
    _builder.append(_addChildVisual, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _removeFixedChild = this.xptLinkEditPart.removeFixedChild(it);
    _builder.append(_removeFixedChild, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _removeChildVisual = this.xptLinkEditPart.removeChildVisual(it);
    _builder.append(_removeChildVisual, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _createLinkFigure = this.xptLinkEditPart.createLinkFigure(it);
    _builder.append(_createLinkFigure, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart");
    return _builder;
  }
  
  public CharSequence implementsList(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isTreeBranch = it.isTreeBranch();
      if (_isTreeBranch) {
        _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence attributes(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPoliciesBody = this.xptLinkEditPart.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
