/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.expressions.edit.internal.utils;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.uml2.uml.Package;

public class PackageUtils {
    public static final Package findPackageFromURI(Package package_, String packageURI, EClass expectedPackageEClass) {
        if (packageURI == null || packageURI.isEmpty() || package_ == null) {
            return null;
        }
        if (packageURI.equals(package_.getURI()) && (expectedPackageEClass == null || expectedPackageEClass == package_.eClass())) {
            return package_;
        }
        Iterator packIter = package_.getNestedPackages().iterator();
        Package foundPackage = null;
        while (packIter.hasNext() && foundPackage == null) {
            foundPackage = PackageUtils.findPackageFromURI((Package)packIter.next(), packageURI, expectedPackageEClass);
        }
        return foundPackage;
    }

    public static final <T> T findPackageFromURI(Package package_, String packageURI, Class<T> expectedType) {
        if (packageURI == null || packageURI.isEmpty() || package_ == null) {
            return null;
        }
        if (packageURI.equals(package_.getURI()) && expectedType.isInstance(package_)) {
            return expectedType.cast(package_);
        }
        Iterator packIter = package_.getNestedPackages().iterator();
        T foundPackage = null;
        while (packIter.hasNext() && foundPackage == null) {
            foundPackage = PackageUtils.findPackageFromURI((Package)packIter.next(), packageURI, expectedType);
        }
        return foundPackage;
    }
}

