/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.handlers.plugins;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.dev.project.management.Activator;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenParentPOMHandler
extends AbstractHandler {
    private final String POM_CONTENT_TYPE = "org.eclipse.m2e.core.pomFile";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IPath parentPath;
            IFile pom = this.getSelectedPOM(HandlerUtil.getActiveMenuSelection((ExecutionEvent)event));
            IPath iPath = parentPath = pom == null ? null : this.getParentPath(pom);
            if (parentPath != null) {
                this.open(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage(), parentPath);
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to open parent POM", (Throwable)e);
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeMenuSelection");
        this.setBaseEnabled(this.getSelectedPOM(selection) != null);
    }

    private IFile getSelectedPOM(Object selection) {
        Object first;
        IFile file;
        IFile result = null;
        if (selection instanceof IStructuredSelection && (file = (IFile)PlatformHelper.getAdapter((Object)(first = ((IStructuredSelection)selection).getFirstElement()), IFile.class)) != null) {
            try {
                IContentType expected = Platform.getContentTypeManager().getContentType("org.eclipse.m2e.core.pomFile");
                if (expected == null) {
                    if (file.getName().equals("pom.xml")) {
                        result = file;
                    }
                } else {
                    IContentType type;
                    IContentDescription desc = file.getContentDescription();
                    IContentType iContentType = type = desc == null ? null : desc.getContentType();
                    if (type != null && type.isKindOf(expected)) {
                        result = file;
                    }
                }
                result = file;
            }
            catch (CoreException e) {
                Activator.log.log(e.getStatus());
            }
        }
        return result;
    }

    private void open(IWorkbenchPage page, IPath pomPath) throws Exception {
        File file = pomPath.toFile();
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] workspaceFiles = ws.findFilesForLocationURI(file.toURI());
        if (workspaceFiles.length > 0) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)workspaceFiles[0]);
        } else {
            String editor = IDE.getEditorDescriptor((String)file.getName()).getId();
            IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editor, (boolean)true);
        }
    }

    IPath getParentPath(IFile pom) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        class ParentHandler
        extends DefaultHandler {
            private StringBuilder parentBuilder;
            private boolean inParent;
            private final /* synthetic */ IFile val$pom;

            ParentHandler(IFile iFile) {
                this.val$pom = iFile;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("parent".equals(localName) || "parent".equals(qName)) {
                    this.inParent = true;
                } else if (this.inParent && ("relativePath".equals(localName) || "relativePath".equals(qName))) {
                    this.parentBuilder = new StringBuilder();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.parentBuilder != null) {
                    this.parentBuilder.append(ch, start, length);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if ("parent".equals(localName) || "parent".equals(qName)) {
                    throw new OperationCanceledException();
                }
                if (this.inParent && ("relativePath".equals(localName) || "relativePath".equals(qName))) {
                    throw new OperationCanceledException();
                }
            }

            IPath getParentPath() {
                IPath result = null;
                IPath location = this.val$pom.getLocation();
                if (location != null) {
                    if (this.parentBuilder == null) {
                        result = location.removeLastSegments(2).append("pom.xml");
                    } else {
                        Path relative = new Path(this.parentBuilder.toString().trim());
                        result = location.removeLastSegments(1).append((IPath)relative);
                        File parent = result.toFile();
                        if (parent.exists() && parent.isDirectory()) {
                            result = result.append("pom.xml");
                        }
                    }
                }
                return result;
            }
        }
        ParentHandler handler = new ParentHandler(pom);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = pom.getContents();){
                parser.parse(input, (DefaultHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return handler.getParentPath();
    }
}

