/**
 * Copyright (c) 2007, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.GenEditorGenerator_qvto;
import xpt.providers.MetricProvider;

@Singleton
@SuppressWarnings("all")
public class ActionBarContributor {
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;
  
  @Inject
  private Editor xptEditor;
  
  @Inject
  private ValidateAction xptValidateAction;
  
  @Inject
  private MetricProvider xptMetricProvider;
  
  public CharSequence className(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _actionBarContributorClassName = it.getActionBarContributorClassName();
    _builder.append(_actionBarContributorClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.parts.DiagramActionBarContributor");
    return _builder;
  }
  
  public CharSequence ActionBarContributor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected Class<");
    CharSequence _qualifiedClassName = this.xptEditor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append("> getEditorClass() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_1 = this.xptEditor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".class;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected String getEditorId() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_2 = this.xptEditor.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(".ID;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initMethod = this.initMethod(it);
    _builder.append(_initMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initMethod(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void init(org.eclipse.ui.IActionBars bars, org.eclipse.ui.IWorkbenchPage page) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.init(bars, page);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// print preview");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.action.IMenuManager fileMenu = bars.getMenuManager().findMenuUsingPath(org.eclipse.ui.IWorkbenchActionConstants.M_FILE);");
    _builder.newLine();
    _builder.append("\t");
    CharSequence __assert = this._common._assert("fileMenu != null");
    _builder.append(__assert, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _isPrintingEnabled = it.getEditorGen().getPlugin().isPrintingEnabled();
      if (_isPrintingEnabled) {
        _builder.append("\t");
        _builder.append("org.eclipse.jface.action.IAction printPreviewAction = new org.eclipse.gmf.runtime.diagram.ui.printing.render.actions.RenderedPrintPreviewAction(new org.eclipse.gmf.runtime.diagram.ui.printing.render.actions.EnhancedPrintActionHelper());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fileMenu.insertBefore(\"print\", printPreviewAction); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        _builder.append("fileMenu.remove(\"pageSetupAction\"); ");
        CharSequence _nonNLS_1 = this._common.nonNLS(1);
        _builder.append(_nonNLS_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if (((it.getEditorGen().getDiagram().isValidationEnabled() || this._genEditorGenerator_qvto.hasAudits(it.getEditorGen())) || ((it.getEditorGen().getMetrics() != null) && this._common_qvto.<GenMetricRule>notEmpty(it.getEditorGen().getMetrics().getMetrics())))) {
        _builder.append("\t");
        _builder.append("org.eclipse.jface.action.IMenuManager editMenu = bars.getMenuManager().findMenuUsingPath(org.eclipse.ui.IWorkbenchActionConstants.M_EDIT);");
        _builder.newLine();
        _builder.append("\t");
        CharSequence __assert_1 = this._common._assert("editMenu != null");
        _builder.append(__assert_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (editMenu.find(\"validationGroup\") == null) { ");
        CharSequence _nonNLS_2 = this._common.nonNLS(1);
        _builder.append(_nonNLS_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("editMenu.add(new org.eclipse.jface.action.GroupMarker(\"validationGroup\")); ");
        CharSequence _nonNLS_3 = this._common.nonNLS(1);
        _builder.append(_nonNLS_3, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        {
          if ((it.getEditorGen().getDiagram().isValidationEnabled() || this._genEditorGenerator_qvto.hasAudits(it.getEditorGen()))) {
            _builder.append("\t");
            _builder.append("org.eclipse.jface.action.IAction validateAction = new ");
            CharSequence _qualifiedClassName = this.xptValidateAction.qualifiedClassName(it.getEditorGen().getDiagram());
            _builder.append(_qualifiedClassName, "\t");
            _builder.append("(page);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("editMenu.appendToGroup(\"validationGroup\", validateAction); ");
            CharSequence _nonNLS_4 = this._common.nonNLS(1);
            _builder.append(_nonNLS_4, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          if (((it.getEditorGen().getMetrics() != null) && this._common_qvto.<GenMetricRule>notEmpty(it.getEditorGen().getMetrics().getMetrics()))) {
            _builder.append("\t");
            _builder.append("org.eclipse.jface.action.IAction metricsAction = new ");
            CharSequence _qualifiedClassName_1 = this.xptMetricProvider.qualifiedClassName(it.getEditorGen().getDiagram());
            _builder.append(_qualifiedClassName_1, "\t");
            _builder.append(".MetricsAction(page);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("editMenu.appendToGroup(\"validationGroup\", metricsAction); ");
            CharSequence _nonNLS_5 = this._common.nonNLS(1);
            _builder.append(_nonNLS_5, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
