/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.expressions.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionCatalog;
import org.eclipse.papyrus.infra.emf.expressions.ExpressionsFactory;
import org.eclipse.papyrus.infra.emf.expressions.util.custom.ExpressionsResourceFactory;
import org.eclipse.papyrus.infra.emf.expressions.utils.ExpressionNameComparator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.util.SelectionHelper;
import org.eclipse.papyrus.toolsmiths.expressions.Activator;
import org.eclipse.papyrus.uml.expressions.umlexpressions.IsStereotypedWithExpression;
import org.eclipse.papyrus.uml.expressions.umlexpressions.UMLExpressionsFactory;
import org.eclipse.papyrus.uml.expressions.umlexpressions.utils.UMLExpressionsUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class GenerateProfileCatalogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Profile profile = this.getSelectedProfile();
        if (profile != null) {
            ExpressionCatalog catalog = this.createExpressionCatalog(profile);
            URI profileURI = profile.eResource().getURI();
            profileURI = profileURI.trimFileExtension();
            profileURI = profileURI.trimFileExtension();
            profileURI = profileURI.appendFileExtension("expressions");
            Resource res = new ExpressionsResourceFactory().createResource(profileURI);
            res.getContents().add((Object)catalog);
            try {
                res.save(null);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getSelectedProfile() != null);
    }

    private Profile getSelectedProfile() {
        IStructuredSelection selection = SelectionHelper.getCurrentStructuredSelection();
        if (selection != null) {
            Object selectedObject = selection.getFirstElement();
            if ((selectedObject = EMFHelper.getEObject((Object)selectedObject)) instanceof Profile) {
                return (Profile)selectedObject;
            }
        }
        return null;
    }

    private ExpressionCatalog createExpressionCatalog(Profile profile) {
        ExpressionCatalog catalog = ExpressionsFactory.eINSTANCE.createExpressionCatalog();
        String profileName = profile.getName();
        StringBuilder catalogNameBuilder = new StringBuilder(profileName);
        catalogNameBuilder.append("ExpressionCatalog");
        catalog.setName(catalogNameBuilder.toString());
        String description = NLS.bind((String)"This catalog provides expressions for the profile {0}.", (Object)profileName);
        catalog.setDescription(description);
        this.fillExpressionExpressionToCatalog(profile, catalog);
        return catalog;
    }

    private void fillExpressionExpressionToCatalog(Profile profile, ExpressionCatalog catalog) {
        ArrayList<IsStereotypedWithExpression> list = new ArrayList<IsStereotypedWithExpression>();
        TreeIterator iter = profile.eAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (!(current instanceof Stereotype)) continue;
            Stereotype stereotype = (Stereotype)current;
            String stereotypeQN = stereotype.getQualifiedName();
            IsStereotypedWithExpression exp = UMLExpressionsFactory.eINSTANCE.createIsStereotypedWithExpression();
            String expressionDescription = NLS.bind((String)"This expression returns TRUE if the Element is stereotyped with {0} and FALSE otherwise.", (Object)stereotypeQN);
            exp.setName("IsStereotypedWith_" + stereotypeQN);
            exp.setDescription(expressionDescription);
            exp.setStereotypeQualifiedName(stereotypeQN);
            exp.setProfileURI(UMLExpressionsUtils.getTopProfileURI((Element)stereotype));
            list.add(exp);
        }
        list.sort((Comparator<IsStereotypedWithExpression>)new ExpressionNameComparator());
        catalog.getExpressions().addAll(list);
    }
}

