/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;

public class TableChecker {
    private static final List<String> ALLOWED_AXIS_ID = new ArrayList<String>();
    private static final String NEWLINE = "\n";
    private static final String UML_GENERIC_TREE_TABLE_TYPE = "PapyrusUMLGenericTreeTable";
    private static final String UML_GENERIC_MATRIX = "UMLGenericMatrixOfRelationships";

    static {
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.infra.emf.nattable.operation.axis.manager");
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.infra.emf.nattable.axis.column.eobject.matrix.manager");
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.uml.nattable.stereotype.property.axis.manager");
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.uml.nattable.feature.axis.manager");
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.infra.uml.nattable.tree.axis.manager");
        ALLOWED_AXIS_ID.add("org.eclipse.papyrus.uml.nattable.operation.axis.manager");
    }

    private TableChecker() {
    }

    public static final IStatus checkTable(Table table) {
        StringBuilder message = new StringBuilder();
        if (table.isInvertAxis()) {
            message.append(Messages.TableChecker_Warning_TableIsInverted);
        }
        TableConfiguration tConfig = table.getTableConfiguration();
        StringBuilder forbiddenRowAxis = new StringBuilder();
        StringBuilder forbiddenColumnAxis = new StringBuilder();
        for (AxisManagerRepresentation currentAxisManager : tConfig.getRowHeaderAxisConfiguration().getAxisManagers()) {
            if (ALLOWED_AXIS_ID.contains(currentAxisManager.getAxisManagerId())) continue;
            forbiddenRowAxis.append(currentAxisManager.getAxisManagerId());
            forbiddenRowAxis.append(NEWLINE);
        }
        for (AxisManagerRepresentation currentAxisManager : tConfig.getColumnHeaderAxisConfiguration().getAxisManagers()) {
            if (ALLOWED_AXIS_ID.contains(currentAxisManager.getAxisManagerId())) continue;
            forbiddenColumnAxis.append(currentAxisManager.getAxisManagerId());
            forbiddenColumnAxis.append(NEWLINE);
        }
        if (forbiddenRowAxis.length() > 0 || forbiddenColumnAxis.length() > 0) {
            message.append(NLS.bind((String)Messages.TableChecker_InformWhichKindOfTableToUseToCreateNewOne, (Object)UML_GENERIC_TREE_TABLE_TYPE, (Object)UML_GENERIC_MATRIX));
        }
        if (forbiddenRowAxis.length() > 0) {
            message.append(NLS.bind((String)Messages.TableChecker_NotRecommendedRowAxis, (Object)forbiddenRowAxis.toString()));
        }
        if (forbiddenColumnAxis.length() > 0) {
            message.append(NLS.bind((String)Messages.TableChecker_NotRecommendedColumnAxis, (Object)forbiddenColumnAxis.toString()));
        }
        if (message.length() == 0) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.papyrus.toolsmiths.nattable", message.toString());
    }
}

