/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusPluginBuilder;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Version;

public class ManifestBuilder
extends AbstractPapyrusBuilder {
    public static final String DEPENDENCY_MARKER_ATTRIBUTE = "dependency";
    public static final String KIND_MARKER_ATTRIBUTE = "kind";
    public static final int REEXPORT_KIND = 0;
    public static final int MISSING_VERSION_RANGE_KIND = 1;
    public static final int MAXIMUM_RANGE_MISSING_KIND = 2;
    public static final int EXCLUDE_MINIMUM_RANGE_KIND = 3;
    public static final int INCLUDE_MAXIMUM_RANGE_KIND = 4;

    @Override
    public IProject[] build(IProject builtProject, PapyrusPluginBuilder papyrusBuilder, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IPluginModelBase pluginModelBase = PluginRegistry.findModel((IProject)builtProject);
        BundleSpecification[] requiredBundles = pluginModelBase.getBundleDescription().getRequiredBundles();
        String message = "";
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            VersionRange versionRange;
            BundleSpecification bundle = bundleSpecificationArray[n2];
            if (bundle.isExported() && this.isCheckReexportActivated()) {
                message = String.valueOf(bundle.getName()) + " : this bundle should not be reexported";
                this.createErrorMarker(pluginModelBase, bundle, message, 0);
            }
            if (this.isCheckDependencyRangeActivated() && (versionRange = bundle.getVersionRange()) != null) {
                if (versionRange.isExact()) {
                    message = String.valueOf(bundle.getName()) + " : we should define range as bundle version";
                    this.createErrorMarker(pluginModelBase, bundle, message, 1);
                } else {
                    if (!versionRange.getIncludeMinimum()) {
                        message = String.valueOf(bundle.getName()) + " : we should include the minimum bundle version -> [";
                        this.createErrorMarker(pluginModelBase, bundle, message, 3);
                    }
                    if (versionRange.getIncludeMaximum()) {
                        message = String.valueOf(bundle.getName()) + " : we should exclude the maximum bundle version -> )";
                        this.createErrorMarker(pluginModelBase, bundle, message, 4);
                    }
                    if (versionRange.getLeft() == null || versionRange.getLeft().equals((Object)Version.emptyVersion)) {
                        message = String.valueOf(bundle.getName()) + " : we should define a minimum bundle version";
                        this.createErrorMarker(pluginModelBase, bundle, message, 1);
                    } else if (versionRange.getRight() == null) {
                        message = String.valueOf(bundle.getName()) + " : we should define a maximum bundle version";
                        this.createErrorMarker(pluginModelBase, bundle, message, 2);
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private void createErrorMarker(IPluginModelBase pluginModelBase, BundleSpecification bundle, String message, int versionRangeMissingKind) {
        IResource manifest = pluginModelBase.getUnderlyingResource();
        IMarker marker = this.createErrorMarker(manifest, message);
        try {
            marker.setAttribute(DEPENDENCY_MARKER_ATTRIBUTE, (Object)bundle.getName());
            marker.setAttribute(KIND_MARKER_ATTRIBUTE, versionRangeMissingKind);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private boolean isCheckReexportActivated() {
        return Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckReexport");
    }

    private boolean isCheckDependencyRangeActivated() {
        return Activator.getDefault().getPreferenceStore().getBoolean("PapyrusManifestBuilder_CheckDependencyRange");
    }
}

