/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.enumeration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.enumeration.IDeleteEnumerationLiteralFromEnumeration;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.DeleteEnumerationLiteralFromEnumerationDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class DeleteEnumerationLiteralFromEnumerationMigrator
extends AbstractMigrator
implements IDeleteEnumerationLiteralFromEnumeration {
    protected Enumeration enumeration;
    protected EnumerationLiteral enumerationLiteral;

    public DeleteEnumerationLiteralFromEnumerationMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        EObject element;
        return TreeNodeUtils.isDeleteType(treeNode, MigratorProfileApplication.appliedProfile) && (element = TreeNodeUtils.getDeletedElement(treeNode)) instanceof EnumerationLiteral && ((EnumerationLiteral)element).getOwner() instanceof Enumeration;
    }

    @Override
    public boolean isValid() {
        return DeleteEnumerationLiteralFromEnumerationMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        if (this.isDisplayDialogPreference()) {
            HashMap mapElementToStereotype = new HashMap();
            List<StereotypeApplicationDescriptor> descriptorList = StereotypeApplicationRegistry.stereotypeApplicationList;
            for (StereotypeApplicationDescriptor descriptor : descriptorList) {
                for (Property property : descriptor.getStereotype().getAllAttributes()) {
                    if (property.getType() != this.enumeration) continue;
                    if (descriptor.getMapPropertyToApplicationValue().get(property) instanceof Collection) {
                        for (EObject object : (Collection)descriptor.getMapPropertyToApplicationValue().get(property)) {
                            if (!((EEnumLiteral)object).getName().equals(this.enumerationLiteral.getName())) continue;
                            if (mapElementToStereotype.containsKey(descriptor.getOwner())) {
                                ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
                                continue;
                            }
                            ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                            stereotypes.add(descriptor.getStereotype());
                            mapElementToStereotype.put(descriptor.getOwner(), stereotypes);
                        }
                        continue;
                    }
                    if (descriptor.getMapPropertyToApplicationValue().get(property) != this.enumerationLiteral && descriptor.getMapPropertyToApplicationValue().get(property) != null) continue;
                    if (mapElementToStereotype.containsKey(descriptor.getOwner())) {
                        ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
                        continue;
                    }
                    ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                    stereotypes.add(descriptor.getStereotype());
                    mapElementToStereotype.put(descriptor.getOwner(), stereotypes);
                }
            }
            if (!mapElementToStereotype.isEmpty()) {
                DeleteEnumerationLiteralFromEnumerationDialog dialog = new DeleteEnumerationLiteralFromEnumerationDialog(Display.getDefault().getActiveShell(), this.enumeration, this.enumerationLiteral, mapElementToStereotype);
                dialog.open();
            }
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            this.enumerationLiteral = (EnumerationLiteral)TreeNodeUtils.getDeletedElement(this.treeNode);
            this.enumeration = (Enumeration)TreeNodeUtils.getDeletedElementOwner(this.treeNode);
        }
    }

    @Override
    public int getPriority() {
        return 50;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("DeleteEnumLiteralFromEnumeration");
    }

    @Override
    public Enumeration getEnumeration() {
        return this.enumeration;
    }

    @Override
    public EnumerationLiteral getEnumerationLiteral() {
        return this.enumerationLiteral;
    }

    @Override
    public Element getDeletedElement() {
        return this.getEnumerationLiteral();
    }

    @Override
    public Element getDeletedElementContainer() {
        return this.getEnumeration();
    }
}

