/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.ArchitectureIndex;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.DiagnosticErrorReporter;
import org.eclipse.pde.internal.core.builders.IncrementalErrorReporter;
import org.eclipse.pde.internal.core.builders.ManifestErrorReporter;
import org.eclipse.pde.internal.core.builders.XMLErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginErrorReporter<T extends EObject>
extends ManifestErrorReporter
implements IPluginChecker2 {
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private static final String POINT = "point";
    private static final String SEPARATOR = "_";
    private final Map<String, ExtensionMatcher<? super T>> requiredExtensionPoints = new HashMap<String, ExtensionMatcher<? super T>>();
    private final Multimap<String, ExtensionChecker<? super T>> extensionCheckers = HashMultimap.create();
    private final Map<String, ExtensionFixProvider<? super T>> extensionFixProviders = new HashMap<String, ExtensionFixProvider<? super T>>();
    private final Set<String> softRequiredExtensionPoints = new HashSet<String>();
    private final Set<String> foundExtensionPoints = new HashSet<String>();
    private final Map<String, String> localURIMappings = new HashMap<String, String>();
    private final IFile modelFile;
    private final T model;
    private final String markerType;
    private final ProblemReport problems;
    private String sourceID;
    private Function<? super T, String> nameFunction;

    public PluginErrorReporter(IFile file, IFile modelFile, T model, Function<? super T, String> nameFunction) {
        this(file, modelFile, (T)model, "org.eclipse.pde.core.problem", nameFunction);
    }

    public PluginErrorReporter(IFile file, IFile modelFile, T model, String markerType, Function<? super T, String> nameFunction) {
        super(file);
        this.modelFile = modelFile;
        this.model = model;
        this.markerType = markerType;
        this.nameFunction = nameFunction;
        this.problems = new ProblemReportImpl();
        this.sourceID = PluginErrorReporter.sourceID(modelFile, model, nameFunction);
    }

    public final IFile getModelFile() {
        return this.modelFile;
    }

    public final T getModel() {
        return this.model;
    }

    public PluginErrorReporter<T> requireExtensionPoint(String point, ExtensionMatcher<? super T> matcher, ExtensionChecker<? super T> checker, ExtensionFixProvider<? super T> fixProvider) {
        this.requiredExtensionPoints.put(point, matcher);
        if (checker != null) {
            this.extensionCheckers.put((Object)point, checker);
        }
        if (fixProvider != null) {
            this.extensionFixProviders.put(point, fixProvider);
        }
        return this;
    }

    public PluginErrorReporter<T> softRequireExtensionPoint(String point, ExtensionMatcher<? super T> matcher, ExtensionChecker<? super T> checker, ExtensionFixProvider<? super T> fixProvider) {
        this.requiredExtensionPoints.put(point, matcher);
        this.softRequiredExtensionPoints.add(point);
        if (checker != null) {
            this.extensionCheckers.put((Object)point, checker);
        }
        if (fixProvider != null) {
            this.extensionFixProviders.put(point, fixProvider);
        }
        return this;
    }

    private void replaceReporter(IFile file, DiagnosticChain diagnostics) {
        try {
            Field errorReporterField = XMLErrorReporter.class.getDeclaredField("fErrorReporter");
            errorReporterField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(modifiersField, modifiersField.getModifiers() & 0xFFFFFFEF);
            errorReporterField.set(this, (Object)new DiagnosticErrorReporter((IResource)file, this.markerType, diagnostics));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private static <T extends EObject> String sourceID(IFile file, T model, Function<? super T, String> nameFunction) {
        StringBuilder builder = new StringBuilder();
        builder.append(model.eClass().getName());
        builder.append(SEPARATOR);
        builder.append(file.getProjectRelativePath().toString());
        builder.append(SEPARATOR);
        String name = nameFunction.apply(model);
        builder.append(name);
        return builder.toString();
    }

    @Override
    public final void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        this.replaceReporter(this.getFile(), diagnostics);
        this.validateContent(monitor);
    }

    public void validate(IProgressMonitor monitor) {
        this.foundExtensionPoints.clear();
        Element element = this.getDocumentRoot();
        if (element == null) {
            return;
        }
        String elementName = element.getNodeName();
        if ("plugin".equals(elementName) || "fragment".equals(elementName)) {
            NodeList children = element.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (monitor.isCanceled()) break;
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 1: {
                        this.validateElement((Element)child);
                        break;
                    }
                }
                ++i;
            }
            HashSet<String> missingExtensionPoints = new HashSet<String>(this.requiredExtensionPoints.keySet());
            missingExtensionPoints.removeAll(this.foundExtensionPoints);
            HashSet<String> acExtensionPoints = new HashSet<String>(this.softRequiredExtensionPoints);
            acExtensionPoints.retainAll(missingExtensionPoints);
            if (!acExtensionPoints.isEmpty() && this.findArchitectureContextReference()) {
                missingExtensionPoints.removeAll(acExtensionPoints);
            }
            if (!missingExtensionPoints.isEmpty()) {
                missingExtensionPoints.forEach(this::reportMissingExtension);
            }
        }
    }

    protected void reportMissingExtension(String point) {
        int severity = 0;
        if (this.softRequiredExtensionPoints.contains(point)) {
            severity = 1;
        }
        IncrementalErrorReporter.VirtualMarker marker = this.reportProblem(NLS.bind((String)Messages.PluginErrorReporter_0, (Object[])new Object[]{point, this.getModelFile().getProjectRelativePath(), this.nameFunction.apply(this.model)}), 1, severity, this.extensionFixProviders.get(point) != null ? this.extensionFixProviders.get(point).problemID(point, this.model) : 0, null, null, "missing_extensions");
        marker.setAttribute("modelName", (Object)this.nameFunction.apply(this.model));
        marker.setAttribute("modelPath", (Object)this.modelFile.getProjectRelativePath().toPortableString());
    }

    protected void validateElement(Element element) {
        String name;
        switch (name = element.getNodeName()) {
            case "extension": {
                this.validateExtension(element);
                break;
            }
        }
    }

    protected void validateExtension(Element element) {
        String pointID = element.getAttribute(POINT);
        if (pointID != null && !pointID.isBlank()) {
            this.matchExtension(element, pointID, this.model).ifPresent(matched -> {
                this.matchedExtensionPoint(pointID);
                this.validateExtension((Element)matched, pointID, this.model);
            });
        }
    }

    protected Optional<Element> matchExtension(Element element, String point, T model) {
        return Optional.ofNullable(this.requiredExtensionPoints.get(point)).flatMap(matcher -> matcher.matchExtension(element, point, model));
    }

    protected void validateExtension(Element element, String point, T model) {
        this.extensionCheckers.get((Object)point).forEach(checker -> checker.checkExtension(element, point, model, this.problems));
    }

    protected void matchedExtensionPoint(String pointID) {
        this.foundExtensionPoints.add(pointID);
    }

    protected IncrementalErrorReporter.VirtualMarker reportProblem(String message, int line, int severity, int fixId, Element element, String attrName, String category) {
        IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, fixId, element, attrName, category);
        this.addMarkerID(marker);
        return marker;
    }

    public IncrementalErrorReporter.VirtualMarker report(String message, int line, int severity, int fixId, Element element, String attrName, String category) {
        IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, fixId, category);
        if (marker == null) {
            return null;
        }
        marker.setAttribute("xmlTree.locationPath", (Object)this.generateLocationPath(element, attrName));
        return marker;
    }

    private String generateLocationPath(Node node, String attrName) {
        if (node == null) {
            return "";
        }
        int childIndex = 0;
        Node previousSibling = node.getPreviousSibling();
        while (previousSibling != null) {
            if (previousSibling instanceof Element) {
                ++childIndex;
            }
            previousSibling = previousSibling.getPreviousSibling();
        }
        StringBuilder sb = new StringBuilder();
        Node parent = node.getParentNode();
        if (parent != null && !(parent instanceof Document)) {
            sb.append(this.generateLocationPath(parent, null));
            sb.append('>');
        }
        this.composeNodeString(node, childIndex, attrName, sb);
        return sb.toString();
    }

    private String composeNodeString(Node node, int index, String attrName, StringBuilder sb) {
        sb.append('(');
        sb.append(index);
        sb.append(')');
        sb.append(node.getNodeName());
        if (attrName != null) {
            sb.append('@');
            sb.append(attrName);
        }
        return sb.toString();
    }

    protected IncrementalErrorReporter.VirtualMarker reportProblem(String message, int line, int severity, String category) {
        IncrementalErrorReporter.VirtualMarker marker = this.report(message, line, severity, category);
        this.addMarkerID(marker);
        return marker;
    }

    private void addMarkerID(IncrementalErrorReporter.VirtualMarker marker) {
        if (marker == null) {
            return;
        }
        this.addMarkerAttribute(marker, "source_id", this.sourceID);
    }

    protected String decodePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("pathmap://")) {
            return this.decodePathmapPath(path);
        }
        if (path.startsWith(PLATFORM_PLUGIN)) {
            return this.decodePlatformPath(path);
        }
        return path;
    }

    protected String decodePlatformPath(String path) {
        return this.cutPluginPath(path);
    }

    protected String decodePathmapPath(String path) {
        String sourceURI;
        String decodePath = null;
        for (Map.Entry<String, String> entry : this.localURIMappings.entrySet()) {
            sourceURI = entry.getKey().toString();
            if (!path.startsWith(sourceURI)) continue;
            String targetURI = entry.getValue();
            decodePath = this.replaceString(path, sourceURI, targetURI);
            return this.cutPluginPath(decodePath);
        }
        for (Map.Entry<String, String> entry : URIMappingRegistryImpl.INSTANCE.entrySet()) {
            sourceURI = ((URI)entry.getKey()).toString();
            if (!path.startsWith(sourceURI)) continue;
            String targetURI = ((URI)entry.getValue()).toString();
            decodePath = this.replaceString(path, sourceURI, targetURI);
            return this.cutPluginPath(decodePath);
        }
        return path;
    }

    protected String cutPluginPath(String decodePath) {
        if (decodePath.startsWith(PLATFORM_PLUGIN)) {
            String cutPath = decodePath.substring(PLATFORM_PLUGIN.length());
            int index = cutPath.indexOf(47);
            cutPath = cutPath.substring(index + 1);
            return cutPath;
        }
        return decodePath;
    }

    protected String replaceString(String path, String sourceURI, String targetURI) {
        String newPath = path.substring(sourceURI.length(), path.length());
        if (!targetURI.endsWith("/")) {
            newPath = "/".concat(newPath);
        }
        newPath = targetURI.concat(newPath);
        return newPath;
    }

    protected boolean findArchitectureContextReference() {
        return ArchitectureIndex.getInstance().isReferenced((EObject)this.getModel());
    }

    public static interface ExtensionChecker<T extends EObject> {
        public void checkExtension(Element var1, String var2, T var3, ProblemReport var4);
    }

    public static interface ExtensionFixProvider<T extends EObject> {
        public int problemID(String var1, T var2);
    }

    public static interface ExtensionMatcher<T extends EObject> {
        public Optional<Element> matchExtension(Element var1, String var2, T var3);
    }

    public static interface ProblemReport {
        public void reportProblem(int var1, Element var2, String var3, String var4, int var5, String var6, Map<String, String> var7);

        public void reportProblem(int var1, Element var2, String var3, String var4, String var5, Map<String, String> var6);

        default public void reportProblem(int severity, Element element, String message, int fixId, String category, Map<String, String> data) {
            this.reportProblem(severity, element, null, message, fixId, category, data);
        }

        default public void reportProblem(int severity, Element element, String message, String category, Map<String, String> data) {
            this.reportProblem(severity, element, null, message, category, data);
        }

        public void reportProblem(int var1, String var2, int var3, String var4, Map<String, String> var5);

        public void reportProblem(int var1, String var2, String var3, Map<String, String> var4);
    }

    private class ProblemReportImpl
    implements ProblemReport {
        private ProblemReportImpl() {
        }

        @Override
        public void reportProblem(int severity, Element element, String attrName, String message, int fixId, String category, Map<String, String> data) {
            IncrementalErrorReporter.VirtualMarker problem = PluginErrorReporter.this.reportProblem(message, this.getLine(element, attrName), this.toCompilerSeverity(severity), fixId, element, attrName, category);
            this.applyData(problem, data);
        }

        @Override
        public void reportProblem(int severity, Element element, String attrName, String message, String category, Map<String, String> data) {
            IncrementalErrorReporter.VirtualMarker problem = PluginErrorReporter.this.reportProblem(message, this.getLine(element, attrName), this.toCompilerSeverity(severity), category);
            this.applyData(problem, data);
        }

        private int getLine(Element element, String attrName) {
            return attrName == null ? PluginErrorReporter.this.getLine(element) : PluginErrorReporter.this.getLine(element, attrName);
        }

        @Override
        public void reportProblem(int severity, String message, int fixId, String category, Map<String, String> data) {
            IncrementalErrorReporter.VirtualMarker problem = PluginErrorReporter.this.report(message, 1, this.toCompilerSeverity(severity), fixId, category);
            this.applyData(problem, data);
        }

        @Override
        public void reportProblem(int severity, String message, String category, Map<String, String> data) {
            IncrementalErrorReporter.VirtualMarker problem = PluginErrorReporter.this.report(message, 1, this.toCompilerSeverity(severity), category);
            this.applyData(problem, data);
        }

        void applyData(IncrementalErrorReporter.VirtualMarker problem, Map<String, String> data) {
            if (data != null) {
                data.forEach((k, v) -> problem.setAttribute(k, v));
            }
        }

        private int toCompilerSeverity(int diagnosticSeverity) {
            switch (diagnosticSeverity) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 1;
                }
                case 4: 
                case 8: {
                    return 0;
                }
            }
            return 2;
        }
    }
}

