/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.quickfix;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ModelResourceMapper;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class StaticProfileHelper {
    private static final String GENMODEL_EXTENSION = "genmodel";

    private StaticProfileHelper() {
    }

    public static final Map<IFile, List<Profile>> findStaticProfiles(IProject builtProject, boolean includeSubProfiles) {
        ModelResourceMapper mapper = new ModelResourceMapper((IContainer)builtProject);
        return Multimaps.asMap((ListMultimap)mapper.map(StaticProfileHelper.diWithGenmodel(), ModelResourceMapper.modelSets(), modelSet -> StaticProfileHelper.getProfiles(modelSet, includeSubProfiles)));
    }

    public static Predicate<IResource> diWithGenmodel() {
        return ModelResourceMapper.byExtension((String)"di").and(file -> StaticProfileHelper.hasGenmodel(file));
    }

    static boolean hasGenmodel(IResource diFile) {
        String fileName = diFile.getFullPath().removeFileExtension().addFileExtension(GENMODEL_EXTENSION).lastSegment();
        IResource genModelResource = diFile.getParent().findMember(fileName);
        return genModelResource instanceof IFile;
    }

    static Stream<Profile> getProfiles(ModelSet modelSet, boolean includeSubProfiles) {
        try {
            EObject root = UmlUtils.getUmlModel((ModelSet)modelSet).lookupRoot();
            if (root instanceof Profile) {
                Profile profile = (Profile)root;
                if (!includeSubProfiles) {
                    return Stream.of(profile);
                }
                return StaticProfileHelper.profileWithSubProfiles(profile);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return Stream.empty();
    }

    public static Stream<Profile> profileWithSubProfiles(Profile profile) {
        return Stream.concat(Stream.of(profile), PackageUtil.getSubProfiles((Package)profile).stream());
    }

    public static Predicate<IResource> umlWithGenmodel() {
        return ModelResourceMapper.byExtension((String)"uml").and(file -> StaticProfileHelper.hasGenmodel(file));
    }
}

