/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class PropertiesContextPluginXMLValidator {
    static final String CATEGORY = "properties-context";
    private final IFile modelFile;

    PropertiesContextPluginXMLValidator(IFile modelFile) {
        this.modelFile = modelFile;
    }

    Optional<Element> matchExtension(Element element, String point, Context contextModel) {
        switch (point) {
            case "org.eclipse.papyrus.infra.properties.contexts": {
                NodeList children = element.getElementsByTagName("context");
                int i = 0;
                while (i < children.getLength()) {
                    Element model = (Element)children.item(i);
                    if (this.matchContext(model, contextModel)) {
                        return Optional.of(model);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    boolean matchContext(Element element, Context model) {
        String path = element.getAttribute("contextModel");
        return Objects.equals(path, this.modelFile.getProjectRelativePath().toString());
    }

    int problemID(String point, Context model) {
        switch (point) {
            case "org.eclipse.papyrus.infra.properties.contexts": {
                return 16715840;
            }
        }
        return -1;
    }
}

