/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.query;

import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.properties.environment.LayoutType;
import org.eclipse.papyrus.infra.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.infra.properties.ui.Layout;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.widgets.CustomizablePropertyEditor;

public class QueryUtil {
    public static boolean matches(SimpleConstraint constraintDescriptor, Class<? extends Constraint> constraintClass) {
        ConstraintType constraintType = constraintDescriptor.getConstraintType();
        return constraintType != null && constraintClass.getName().equals(constraintType.getConstraintClass());
    }

    public static boolean matches(PropertyEditor propertyEditor, Class<? extends CustomizablePropertyEditor> propertyEditorClass) {
        PropertyEditorType widgetType = propertyEditor.getWidgetType();
        return widgetType != null && widgetType.getNamespace() != null && propertyEditorClass.getSimpleName().equals(widgetType.getWidgetClass()) && propertyEditorClass.getPackageName().equals(widgetType.getNamespace().getValue());
    }

    public static boolean matches(Layout layout, Class<? extends org.eclipse.swt.widgets.Layout> layoutClass) {
        return QueryUtil.matches(layout, layoutClass, true);
    }

    public static boolean matches(Layout layout, Class<? extends org.eclipse.swt.widgets.Layout> layoutClass, boolean withNamespace) {
        LayoutType layoutType = layout.getLayoutType();
        if (layoutType == null || !layoutClass.getSimpleName().equals(layoutType.getWidgetClass())) {
            return false;
        }
        if (withNamespace) {
            return layoutType.getNamespace() != null && layoutClass.getPackageName().equals(layoutType.getNamespace().getValue());
        }
        return layoutType.getNamespace() == null;
    }
}

