/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.calculation.AbstractCompositeCalculation;
import ca.odell.glazedlists.calculation.Calculation;

final class Division {
    Division() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DivisionDouble
    extends AbstractCompositeCalculation<Double> {
        public DivisionDouble(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
            super(numerator, denominator);
        }

        @Override
        protected Double recompute(Number[] inputs) {
            double numerator = inputs[0].doubleValue();
            double denominator = inputs[1].doubleValue();
            return new Double(numerator / denominator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DivisionFloat
    extends AbstractCompositeCalculation<Float> {
        public DivisionFloat(Calculation<? extends Number> numerator, Calculation<? extends Number> denominator) {
            super(numerator, denominator);
        }

        @Override
        protected Float recompute(Number[] inputs) {
            float numerator = inputs[0].floatValue();
            float denominator = inputs[1].floatValue();
            return new Float(numerator / denominator);
        }
    }
}

