/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.uml2.uml.Pseudostate;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Connection Point Reference Rule</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference.ConnectionPointReferenceRule#getEntry <em>Entry</em>}</li>
 *   <li>{@link org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference.ConnectionPointReferenceRule#getExit <em>Exit</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference.UMLConnectionPointReferencePackage#getConnectionPointReferenceRule()
 * @model
 * @generated
 */
public interface ConnectionPointReferenceRule extends EObject
{
  /**
   * Returns the value of the '<em><b>Entry</b></em>' reference list.
   * The list contents are of type {@link org.eclipse.uml2.uml.Pseudostate}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Entry</em>' reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Entry</em>' reference list.
   * @see org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference.UMLConnectionPointReferencePackage#getConnectionPointReferenceRule_Entry()
   * @model
   * @generated
   */
  EList<Pseudostate> getEntry();

  /**
   * Returns the value of the '<em><b>Exit</b></em>' reference list.
   * The list contents are of type {@link org.eclipse.uml2.uml.Pseudostate}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Exit</em>' reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Exit</em>' reference list.
   * @see org.eclipse.papyrus.connectionpointreference.editor.xtext.uMLConnectionPointReference.UMLConnectionPointReferencePackage#getConnectionPointReferenceRule_Exit()
   * @model
   * @generated
   */
  EList<Pseudostate> getExit();

} // ConnectionPointReferenceRule
