/**
 * 
 */
package org.eclipse.papyrus.resource.notation;

import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.resource.AbstractBaseModel;
import org.eclipse.papyrus.resource.IModel;
import org.eclipse.papyrus.resource.ModelSet;


/**
 * @author dumoulin
 *
 */
public class NotationModel extends AbstractBaseModel implements IModel {

	/**
	 * File extension used for notation.
	 */
	public static final String NOTATION_FILE_EXTENSION = "notation"; //$NON-NLS-1$

	/**
	 *  Model ID.
	 */
	public static final String MODEL_ID = "org.eclipse.papyrus.resource.notation.NotationModel"; //$NON-NLS-1$


	/**
	 * 
	 * Constructor.
	 *
	 */
	public NotationModel() {
		
	}
	
	// Initialize stuff in the model.
	@Override
	public void init(ModelSet modelManager) {
		super.init(modelManager);
		// Specify the factory to use to create the resource.
		GMFResourceFactory gmfFactory = new GMFResourceFactory();
		getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put(NOTATION_FILE_EXTENSION, gmfFactory);

	}
	/**
	 * Get the file extension used for this model.
	 * @see org.eclipse.papyrus.resource.AbstractBaseModel#getModelFileExtension()
	 *
	 * @return
	 */
	@Override
	protected String getModelFileExtension() {
		return NOTATION_FILE_EXTENSION;
	}

	/**
	 * Get the identifier used to register this model.
	 * @see org.eclipse.papyrus.resource.AbstractBaseModel#getIdentifier()
	 *
	 * @return
	 */
	@Override
	public String getIdentifier() {
		return MODEL_ID;
	}


	/**
	 * Add a new initialized {@link Diagram} to the model.
	 * @param newDiagram The diagram to add.
	 */
	public void addDiagram( Diagram newDiagram) {
		getResource().getContents().add(newDiagram);
	}
}
