package org.eclipse.papyrus.core.services;

import org.eclipse.papyrus.core.services.IServiceFactory;


/**
 * Fake service factory for testing purpose.
 * 
 * @author cedric dumoulin
 *
 */
public class FakeServiceFactory extends FakeService implements IServiceFactory {


	/**
	 * 
	 * Constructor.
	 *
	 */
	public FakeServiceFactory() {

		super( "factoryName" + count++ );
	}
	
	/**
	 * Constructor.
	 *
	 * @param name
	 */
	public FakeServiceFactory(String name) {
		super(name);
	}

	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Create the service
	 * @see org.eclipse.papyrus.core.services.IServiceFactory#createServiceInstance()
	 *
	 * @return
	 */
	public Object createServiceInstance() {
		trace.addTrace(getName(), "createInstance");
		return new FakeCreatedService();
	}

	/**
	 * Pseudo service created by the factory.
	 * @author dumoulin
	 *
	 */
	public class FakeCreatedService {
		
		/**
		 * @return the name
		 */
		public String getName() {
			return name;
		}		
	}
}
