/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Patrick Tessier (CEA LIST) Patrick.tessier@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.diagram.common.figure.node;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

/**
 * this figure is used to display a diamond
 *
 */
public class DiamondNode extends PapyrusNodeFigure implements IPapyrusNodeUMLElementFigure{
/**
 * 
 * {@inheritDoc}
 */
	@Override
	public Dimension getPreferredSize(int wHint, int hHint) {
		// TODO Auto-generated method stub
		return new Dimension(20,20);
	}

/**
 * 
  * {@inheritDoc}
 */
	protected Border getDefaultBorder(Color borderColor) {
		return null;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void paintFigure(Graphics graphics) {
		graphics.pushState();
		Rectangle r = getBounds().getCopy().crop(new Insets(0,0,1,1));
		PointList ptList= new PointList();
		ptList.addPoint(r.x+(r.width/2), r.y);
		ptList.addPoint(r.x+r.width, r.y+(r.height/2));
		ptList.addPoint(r.x+(r.width/2), r.y+(r.height));
		ptList.addPoint(r.x, r.y+(r.height/2));
		
		if(isUsingGradient()) {
			graphics.setBackgroundColor(FigureUtilities.integerToColor(getGradientColor2()));
			//graphics.setForegroundColor(FigureUtilities.integerToColor(getGradientColor2()));
		}
		else{
		graphics.setBackgroundColor(getBackgroundColor());
		//graphics.setForegroundColor(getBackgroundColor);
		}
		graphics.fillPolygon(ptList);
		graphics.setLineWidth(1);
		graphics.setBackgroundColor(getForegroundColor());
		graphics.drawPolygon(ptList);
		graphics.popState();
		

	}
	/**
	 * {@inheritDoc}
	 */
	public void setStereotypeDisplay(String stereotypes, Image image) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * {@inheritDoc}
	 */
	public void setStereotypePropertiesInBrace(String stereotypeProperties) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * {@inheritDoc}
	 */
	public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * {@inheritDoc}
	 */
	public Label getStereotypesLabel() {
		return new Label();
	}
}
