/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *****************************************************************************/
package org.eclipse.papyrus.sysml.diagram.internalblock.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.sysml.diagram.internalblock.Activator;

public class DiagramPreferenceInitializer extends AbstractPreferenceInitializer {

	protected IPreferenceStore getPreferenceStore() {
		return Activator.getDefault().getPreferenceStore();
	}

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = getPreferenceStore();

		PortPreferencePage.initDefaults(store);
		BlockPreferencePage.initDefaults(store);
		PropertyPreferencePage.initDefaults(store);
		CommentPreferencePage.initDefaults(store);
		ConstraintPreferencePage.initDefaults(store);
		ConnectorPreferencePage.initDefaults(store);
		CommentAnnotatedElementPreferencePage.initDefaults(store);
		ConstraintConstrainedElementPreferencePage.initDefaults(store);
	}
}
