/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.editor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.MoveModelElement;
import org.eclipse.emf.compare.match.engine.GenericMatchScopeProvider;
import org.eclipse.emf.compare.match.engine.IMatchScopeProvider;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.compare.common.editor.EMFCompareEditor;
import org.eclipse.papyrus.infra.emf.compare.common.utils.PapyrusModelCompareEditorInput;
import org.eclipse.papyrus.infra.emf.compare.instance.papyrusemfcompareinstance.PapyrusEMFCompareInstance;
import org.eclipse.papyrus.infra.emf.compare.ui.provider.EMFCompareLabelProvider;
import org.eclipse.papyrus.uml.compare.utils.UMLDiffService;
import org.eclipse.papyrus.uml.compare.utils.UMLMatchEngine;
import org.eclipse.papyrus.uml.compare.utils.UMLModelCompareEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLCompareEditor
extends EMFCompareEditor {
    public static final String EDITOR_TYPE = "PapyrusUMLCompare";

    public UMLCompareEditor(ServicesRegistry servicesRegistry, PapyrusEMFCompareInstance rawModel) {
        super(servicesRegistry, rawModel);
    }

    protected Map<String, Object> getCompareOptions(IProgressMonitor monitor, EObject leftObject, EObject rightObject) {
        Map options = super.getCompareOptions(monitor, leftObject, rightObject);
        options.put("match.progress.monitor", monitor);
        options.put("match.ignore.id", Boolean.TRUE);
        options.put("match.ignore.xmi.id", Boolean.TRUE);
        options.put("match.scope.provider", this.getMatchScopeProvider(leftObject, rightObject));
        return options;
    }

    protected IMatchScopeProvider getMatchScopeProvider(EObject left, EObject right) {
        return new GenericMatchScopeProvider(left, right);
    }

    protected MatchModel doContentMatch(EObject left, EObject right, Map<String, Object> options) throws InterruptedException {
        UMLMatchEngine engine = new UMLMatchEngine();
        MatchModel result = engine.contentMatch(left, right, options);
        engine.reset();
        return result;
    }

    protected ComparisonSnapshot doContentCompare(EObject left, EObject right) {
        ComparisonSnapshot snapshot = super.doContentCompare(left, right);
        this.cleanSnapshot(snapshot);
        return snapshot;
    }

    protected DiffModel doDiff(MatchModel match) {
        return UMLDiffService.doDiff(match, false);
    }

    private void cleanSnapshot(ComparisonSnapshot snapshot) {
        EList contents = snapshot.eContents();
        DiffModel root = (DiffModel)contents.get(0);
        EList differences = root.getDifferences();
        ArrayList<DiffElement> toRemove = new ArrayList<DiffElement>();
        for (DiffElement current : differences) {
            if (!(current instanceof MoveModelElement)) continue;
            EObject leftTarget = ((MoveModelElement)current).getLeftTarget();
            EObject rightTarget = ((MoveModelElement)current).getRightTarget();
            if (leftTarget != null || rightTarget != null) continue;
            toRemove.add(current);
        }
        for (DiffElement current : toRemove) {
            EcoreUtil.remove((EObject)current);
        }
    }

    protected ModelCompareEditorInput createModelCompareEditorInput(ComparisonSnapshot snapshot) {
        return new UMLModelCompareEditorInput(snapshot, (IEditorPart)this);
    }

    protected void configureInput(PapyrusModelCompareEditorInput input) {
        EObject right;
        CompareConfiguration cc = input.getCompareConfiguration();
        EMFCompareLabelProvider prov = this.getLabelProvider();
        String leftQName = null;
        String rightQName = null;
        EObject left = this.rawModel.getLeft();
        if (left instanceof NamedElement) {
            leftQName = ((NamedElement)left).getQualifiedName();
        }
        if ((right = this.rawModel.getRight()) instanceof NamedElement) {
            rightQName = ((NamedElement)right).getQualifiedName();
        }
        cc.setLeftLabel(leftQName);
        cc.setRightLabel(rightQName);
        cc.setLeftImage(prov.getImage((Object)left));
        cc.setRightImage(prov.getImage((Object)right));
        cc.setProperty("leftObject", (Object)this.rawModel.getLeft());
        cc.setProperty("rightObject", (Object)this.rawModel.getRight());
    }
}

