/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.tools.util.ReflectHelper;
import org.eclipse.papyrus.uml.compare.Activator;
import org.eclipse.papyrus.uml.compare.utils.UMLDiffEngine;

public class UMLDiffService {
    private static Method fillRequiredDifferencesMethod = null;

    private UMLDiffService() {
    }

    public static DiffModel doDiff(MatchModel match, boolean threeWay) {
        UMLDiffEngine engine = new UMLDiffEngine();
        DiffModel diff = engine.doDiff(match, threeWay);
        Collection extensions = DiffService.getCorrespondingDiffExtensions((MatchModel)match);
        for (AbstractDiffExtension ext : extensions) {
            if (ext == null) continue;
            ext.visit(diff);
        }
        engine.reset();
        UMLDiffService.fillRequiredDifferences(diff);
        return diff;
    }

    private static void fillRequiredDifferences(DiffModel diff) {
        if (fillRequiredDifferencesMethod == null) {
            try {
                fillRequiredDifferencesMethod = ReflectHelper.getMethod(DiffService.class, (String)"fillRequiredDifferences", (Class[])new Class[]{EObject.class});
            }
            catch (SecurityException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                Activator.log.error((Throwable)e);
            }
        }
        Object[] parameters = new Object[]{diff};
        try {
            fillRequiredDifferencesMethod.invoke(null, parameters);
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

