/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.customization.palette.dialog.PaletteAspectToolEntryProxy;
import org.eclipse.papyrus.customization.palette.dialog.PaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectActionsInformationComposite {
    private static final String ICONS_ADD = "/icons/obj16/Add_16x16.gif";
    protected static final String ICONS_REMOVE = "/icons/delete.gif";
    protected static final String ICONS_UP = "/icons/arrow_up.gif";
    protected static final String ICONS_DOWN = "/icons/arrow_down.gif";
    protected Text nameText;
    protected Text descriptionText;
    protected Text iconText;
    protected Text referencedText;
    protected PaletteEntryProxy selectedEntryProxy;
    protected TreeViewer viewer;
    protected PageBook actionDescriptionComposite;
    protected List<Profile> appliedProfiles;
    protected Button removeActionButton;
    protected Button addActionButton;
    protected Button moveUpActionButton;
    protected Button moveDownActionButton;

    public Composite createComposite(Composite parent, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 4;
        composite.setLayoutData((Object)data);
        Composite actionList = new Composite(composite, 0);
        layout = new GridLayout(5, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        actionList.setLayout((Layout)layout);
        data = new GridData(4, 4, false, true);
        actionList.setLayoutData((Object)data);
        Label aspectListLabel = new Label(actionList, 16384);
        aspectListLabel.setText(Messages.Aspect_Action_Information_List_Label);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 5;
        aspectListLabel.setLayoutData((Object)data);
        this.addActionButton = new Button(actionList, 0);
        this.addActionButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ICONS_ADD));
        this.addActionButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                AspectActionsInformationComposite.this.addButtonPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.removeActionButton = new Button(actionList, 0);
        this.removeActionButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ICONS_REMOVE));
        this.removeActionButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ITreeSelection selection = (ITreeSelection)AspectActionsInformationComposite.this.viewer.getSelection();
                if (selection != null && selection.size() > 0) {
                    for (Object selected : selection.toList()) {
                        if (!(selected instanceof IPostAction) || !(AspectActionsInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy)) continue;
                        ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPostActions().remove(selected);
                    }
                }
                AspectActionsInformationComposite.this.setSelectedEntryProxy(AspectActionsInformationComposite.this.selectedEntryProxy);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.moveUpActionButton = new Button(actionList, 0);
        this.moveUpActionButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ICONS_UP));
        this.moveUpActionButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AspectActionsInformationComposite.this.viewer.getSelection();
                if (selection != null && selection.size() > 0 && AspectActionsInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
                    IAspectAction action = (IAspectAction)selection.getFirstElement();
                    List<IPreAction> initialPreList = ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPreActions();
                    List<IPostAction> initialPostList = ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPostActions();
                    if (action instanceof IPreAction) {
                        if (initialPreList.indexOf(action) > 0) {
                            Collections.swap(initialPreList, initialPreList.indexOf(action), initialPreList.indexOf(action) - 1);
                        }
                    } else if (action instanceof IPostAction && initialPostList.indexOf(action) > 0) {
                        Collections.swap(initialPostList, initialPostList.indexOf(action), initialPostList.indexOf(action) - 1);
                    }
                    ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).setPreActions(initialPreList);
                    ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).setPostActions(initialPostList);
                    AspectActionsInformationComposite.this.viewer.setInput((Object)AspectActionsInformationComposite.this.selectedEntryProxy);
                    AspectActionsInformationComposite.this.viewer.setSelection((ISelection)new StructuredSelection((Object)action), true);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.moveDownActionButton = new Button(actionList, 0);
        this.moveDownActionButton.setImage(Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ICONS_DOWN));
        this.moveDownActionButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AspectActionsInformationComposite.this.viewer.getSelection();
                if (selection != null && selection.size() > 0 && AspectActionsInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
                    IAspectAction action = (IAspectAction)selection.getFirstElement();
                    List<IPreAction> initialPreList = ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPreActions();
                    List<IPostAction> initialPostList = ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPostActions();
                    if (action instanceof IPreAction) {
                        if (initialPreList.indexOf(action) < initialPreList.size() - 1) {
                            Collections.swap(initialPreList, initialPreList.indexOf(action), initialPreList.indexOf(action) + 1);
                        }
                    } else if (action instanceof IPostAction && initialPostList.indexOf(action) < initialPostList.size() - 1) {
                        Collections.swap(initialPostList, initialPostList.indexOf(action), initialPostList.indexOf(action) + 1);
                    }
                    ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).setPreActions(initialPreList);
                    ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).setPostActions(initialPostList);
                    AspectActionsInformationComposite.this.viewer.setInput((Object)AspectActionsInformationComposite.this.selectedEntryProxy);
                    AspectActionsInformationComposite.this.viewer.setSelection((ISelection)new StructuredSelection((Object)action), true);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.updateButtons();
        this.viewer = new TreeViewer(actionList, 2048);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 5;
        data.heightHint = 150;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AspectActionLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new AspectActionContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AspectActionsInformationComposite.this.handleActionListSelectionChanged(event);
            }
        });
        this.actionDescriptionComposite = new PageBook(composite, 0);
        data = new GridData(4, 4, true, true);
        this.actionDescriptionComposite.setLayoutData((Object)data);
        return composite;
    }

    protected void addButtonPressed() {
        Menu menu = new Menu((Control)this.addActionButton);
        for (IAspectActionProvider factory : AspectToolService.getInstance().getProviders()) {
            if (!factory.isEnable((IPaletteEntryProxy)this.selectedEntryProxy)) continue;
            MenuItem item = new MenuItem(menu, 0);
            item.setText(factory.getName());
            item.setImage(factory.getImage());
            item.setData((Object)factory);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IAspectActionProvider factory = (IAspectActionProvider)((MenuItem)e.getSource()).getData();
                    IAspectAction action = factory.createAction(null);
                    if (AspectActionsInformationComposite.this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
                        if (action instanceof IPostAction) {
                            ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPostActions().add((IPostAction)action);
                        } else {
                            ((PaletteAspectToolEntryProxy)AspectActionsInformationComposite.this.selectedEntryProxy).getPreActions().add((IPreAction)action);
                        }
                        AspectActionsInformationComposite.this.setSelectedEntryProxy(AspectActionsInformationComposite.this.selectedEntryProxy);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        menu.setVisible(true);
    }

    protected void handleActionListSelectionChanged(SelectionChangedEvent event) {
        if (event == null) {
            this.actionDescriptionComposite.showPage((Control)new Composite((Composite)this.actionDescriptionComposite, 0));
            this.removeActionButton.setEnabled(false);
        } else {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && selection.getFirstElement() instanceof IAspectAction) {
                this.actionDescriptionComposite.showPage(((IAspectAction)selection.getFirstElement()).createConfigurationComposite((Composite)this.actionDescriptionComposite, (IPaletteEntryProxy)this.selectedEntryProxy, this.appliedProfiles));
                this.removeActionButton.setEnabled(true);
            } else {
                this.actionDescriptionComposite.showPage((Control)new Composite((Composite)this.actionDescriptionComposite, 0));
                this.removeActionButton.setEnabled(false);
            }
        }
    }

    public void setSelectedEntryProxy(PaletteEntryProxy selectedEntryProxy) {
        this.selectedEntryProxy = selectedEntryProxy;
        if (this.viewer != null) {
            this.viewer.setInput((Object)selectedEntryProxy);
            this.handleActionListSelectionChanged(null);
            if (selectedEntryProxy instanceof PaletteAspectToolEntryProxy && ((PaletteAspectToolEntryProxy)selectedEntryProxy).getPostActions().size() > 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)((PaletteAspectToolEntryProxy)selectedEntryProxy).getPostActions().get(0)), true);
            }
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        if (this.selectedEntryProxy instanceof PaletteAspectToolEntryProxy) {
            this.addActionButton.setEnabled(true);
            if (((PaletteAspectToolEntryProxy)this.selectedEntryProxy).getAspectActions().size() > 0) {
                this.removeActionButton.setEnabled(true);
                this.moveUpActionButton.setEnabled(true);
                this.moveDownActionButton.setEnabled(true);
            } else {
                this.removeActionButton.setEnabled(false);
                this.moveUpActionButton.setEnabled(false);
                this.moveDownActionButton.setEnabled(false);
            }
        } else {
            this.addActionButton.setEnabled(false);
            this.removeActionButton.setEnabled(false);
            this.moveUpActionButton.setEnabled(false);
            this.moveDownActionButton.setEnabled(false);
        }
    }

    protected class AspectActionContentProvider
    implements ITreeContentProvider {
        protected AspectActionContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PaletteAspectToolEntryProxy) {
                return ((PaletteAspectToolEntryProxy)parentElement).getPostActions().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IAspectAction) {
                return AspectActionsInformationComposite.this.selectedEntryProxy;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class AspectActionLabelProvider
    implements ILabelProvider {
        protected AspectActionLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IAspectAction) {
                return ((IAspectAction)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IAspectAction) {
                return ((IAspectAction)element).getLabel();
            }
            return "notAnAction";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

