/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.AbstractQVTGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.FileChooser;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.root.PropertiesRoot;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileGenerator
extends AbstractQVTGenerator {
    private FileChooser sourceFileChooser;
    private Profile umlProfile;

    @Override
    public void createControls(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        root.setLayout((Layout)layout);
        Label sourceLabel = new Label(root, 0);
        sourceLabel.setText(Messages.ProfileGenerator_source);
        GridData data = new GridData();
        data.widthHint = 100;
        sourceLabel.setLayoutData((Object)data);
        this.sourceFileChooser = new FileChooser(root, false);
        this.sourceFileChooser.setFilterExtensions(new String[]{"profile.uml"});
        this.sourceFileChooser.addListener(this);
    }

    @Override
    public String getDescription() {
        return Messages.ProfileGenerator_description;
    }

    @Override
    public boolean isReady() {
        return this.sourceFileChooser.getFilePath() != null;
    }

    @Override
    public String getName() {
        return Messages.ProfileGenerator_name;
    }

    @Override
    protected List<ModelExtent> getModelExtents() {
        try {
            URI profileURI = URI.createPlatformResourceURI((String)this.sourceFileChooser.getFilePath(), (boolean)true);
            this.umlProfile = (Profile)this.loadEMFModel(profileURI);
            BasicModelExtent inProfile = new BasicModelExtent(Collections.singletonList(this.umlProfile));
            URI umlURI = URI.createURI((String)"ppe:/context/org.eclipse.papyrus.uml.properties/Model/UML/UML.ctx", (boolean)true);
            Context umlContext = (Context)this.loadEMFModel(umlURI);
            if (umlContext == null) {
                Activator.log.warn("Cannot find the UML Property View configuration");
            }
            BasicModelExtent inUml = new BasicModelExtent(Collections.singletonList(umlContext));
            PropertiesRoot root = ConfigurationManager.instance.getPropertiesRoot();
            BasicModelExtent inRoot = new BasicModelExtent(Collections.singletonList(root));
            LinkedList<ModelExtent> result = new LinkedList<ModelExtent>();
            result.add((ModelExtent)inProfile);
            result.add(this.getOutContextExtent());
            result.add((ModelExtent)inUml);
            result.add((ModelExtent)inRoot);
            return result;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    @Override
    protected URI getTransformationURI() {
        return URI.createPlatformPluginURI((String)"org.eclipse.papyrus.customization.properties.generation/transforms/profile2datacontext.qvto", (boolean)true);
    }

    protected Classifier findClassifier(List<String> path, Package rootPackage) {
        NamedElement element = rootPackage.getOwnedMember(path.get(0));
        path.remove(0);
        if (path.size() == 0) {
            if (element instanceof Classifier) {
                return (Classifier)element;
            }
        } else if (element instanceof Package) {
            return this.findClassifier(path, (Package)element);
        }
        return null;
    }

    private List<String> getPath(org.eclipse.papyrus.views.properties.contexts.Property property) {
        List<String> result = this.getPath(property.getContextElement());
        return result;
    }

    private List<String> getPath(DataContextElement element) {
        List<Object> result = element.getPackage() == null ? new LinkedList() : this.getPath((DataContextElement)element.getPackage());
        result.add(element.getName());
        return result;
    }

    public Property getAttribute(org.eclipse.papyrus.views.properties.contexts.Property property) {
        List<String> path = this.getPath(property);
        Package propertyRootPackage = this.findPackage(path.remove(0));
        if (propertyRootPackage == null) {
            return null;
        }
        Classifier classifier = this.findClassifier(path, propertyRootPackage);
        if (classifier == null) {
            return null;
        }
        Property attribute = classifier.getAttribute(property.getName(), null);
        return attribute;
    }

    public Package findPackage(String name) {
        for (Resource resource : this.umlProfile.eResource().getResourceSet().getResources()) {
            for (Object rootElement : resource.getContents()) {
                Package rootPackage;
                if (!(rootElement instanceof Package) || !name.equals((rootPackage = (Package)rootElement).getName())) continue;
                return rootPackage;
            }
        }
        return null;
    }

    @Override
    public boolean isSelectedSingle(org.eclipse.papyrus.views.properties.contexts.Property property) {
        Property attribute = this.getAttribute(property);
        if (attribute == null) {
            Activator.log.warn("Cannot find the Property corresponding to " + this.getPath(property));
            return false;
        }
        if (attribute.isDerived()) {
            return false;
        }
        return !attribute.isReadOnly();
    }

    @Override
    public boolean isSelectedMultiple(org.eclipse.papyrus.views.properties.contexts.Property property) {
        if (!this.isSelectedSingle(property)) {
            return false;
        }
        Property attribute = this.getAttribute(property);
        HashSet<String> validDataTypes = new HashSet<String>(Arrays.asList("Integer", "Boolean", "Float", "Double"));
        if (attribute.getType() instanceof PrimitiveType) {
            return validDataTypes.contains(((PrimitiveType)attribute.getType()).getName());
        }
        return attribute.getType() instanceof Enumeration;
    }

    @Override
    public boolean isSelectedSingle(org.eclipse.papyrus.views.properties.contexts.Property property, DataContextElement element) {
        return this.isSelectedSingle(property);
    }

    @Override
    public boolean isSelectedMultiple(org.eclipse.papyrus.views.properties.contexts.Property property, DataContextElement element) {
        return this.isSelectedMultiple(property);
    }
}

