/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.ContextElement;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelection;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelectionFactory;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelectionPackage;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.PropertyDefinition;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.TernaryButton;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.views.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFieldsPage
extends AbstractCreateContextPage {
    private URI targetURI;
    private List<Context> contexts;
    private Composite root;
    private Composite fields;
    private FieldSelection fieldSelection;

    protected SelectFieldsPage() {
        super(Messages.SelectFieldsPage_title);
    }

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        this.root.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)this.root);
        this.setPageComplete(false);
        this.setDescription(Messages.SelectFieldsPage_selectFields);
    }

    public void setContexts(List<Context> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            Activator.log.warn("Generated context is null");
            return;
        }
        this.contexts = contexts;
        this.fieldSelection = this.createNewFieldSelection();
        this.getWizard().setContexts(contexts);
        Label label = new Label(this.root, 0);
        label.setText(Messages.SelectFieldsPage_availableFields);
        ScrolledComposite scrollableFields = new ScrolledComposite(this.root, 768);
        scrollableFields.setLayoutData((Object)new GridData(4, 4, true, true));
        scrollableFields.getVerticalBar().setIncrement(10);
        this.fields = new Composite((Composite)scrollableFields, 0);
        scrollableFields.setContent((Control)this.fields);
        this.fields.setLayout((Layout)new GridLayout(4, false));
        Label fieldLabel = new Label(this.fields, 0);
        Label selectionSingle = new Label(this.fields, 0);
        Label selectionMultiple = new Label(this.fields, 0);
        Label descriptionLabel = new Label(this.fields, 0);
        selectionSingle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectionMultiple.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        descriptionLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        fieldLabel.setText(Messages.SelectFieldsPage_field);
        selectionSingle.setText(Messages.SelectFieldsPage_displaySingle);
        selectionMultiple.setText(Messages.SelectFieldsPage_displayMultiple);
        descriptionLabel.setText(Messages.SelectFieldsPage_description);
        for (Context context : contexts) {
            for (DataContextRoot dataContextRoot : context.getDataContexts()) {
                this.displayFields((DataContextElement)dataContextRoot);
            }
        }
        this.fields.setSize(this.fields.computeSize(-1, -1));
        this.root.layout();
        this.fields.layout();
        scrollableFields.layout();
    }

    private FieldSelection createNewFieldSelection() {
        FieldSelection selection = FieldSelectionFactory.eINSTANCE.createFieldSelection();
        for (Context context : this.contexts) {
            for (DataContextRoot dataContextRoot : context.getDataContexts()) {
                ContextElement definition = this.createContextPackage((DataContextPackage)dataContextRoot);
                selection.getContextElements().add((Object)definition);
            }
        }
        return selection;
    }

    private ContextElement createContextPackage(DataContextPackage sourcePackage) {
        ContextElement element = this.createContextElement((DataContextElement)sourcePackage);
        for (DataContextElement sourceElement : sourcePackage.getElements()) {
            ContextElement subElement = sourceElement instanceof DataContextPackage ? this.createContextPackage((DataContextPackage)sourceElement) : this.createContextElement(sourceElement);
            element.getElements().add((Object)subElement);
        }
        return element;
    }

    private ContextElement createContextElement(DataContextElement sourceElement) {
        ContextElement element = FieldSelectionFactory.eINSTANCE.createContextElement();
        element.setName(sourceElement.getName());
        for (Property property : sourceElement.getProperties()) {
            PropertyDefinition propertyDefinition = FieldSelectionFactory.eINSTANCE.createPropertyDefinition();
            propertyDefinition.setName(property.getName());
            propertyDefinition.setValueSingle(TernaryButton.State.DEFAULT);
            propertyDefinition.setValueMultiple(TernaryButton.State.DEFAULT);
            element.getProperties().add((Object)propertyDefinition);
        }
        return element;
    }

    private void displayFields(DataContextElement contextElement) {
        if (contextElement.getProperties().size() > 0) {
            FontData[] fontDatas;
            Label separator = new Label(this.fields, 258);
            GridData data = new GridData(4, 0x1000000, true, false, 4, 1);
            separator.setLayoutData((Object)data);
            Label elementName = new Label(this.fields, 0);
            elementName.setText(contextElement.getName());
            FontData[] fontDataArray = fontDatas = elementName.getFont().getFontData();
            int n = fontDatas.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fontData = fontDataArray[n2];
                fontData.setStyle(1);
                ++n2;
            }
            elementName.setFont(new Font((Device)elementName.getDisplay(), fontDatas));
            data = new GridData(4, 0x1000000, true, false, 4, 1);
            elementName.setLayoutData((Object)data);
            Label separator2 = new Label(this.fields, 258);
            data = new GridData(4, 0x1000000, true, false, 4, 1);
            separator2.setLayoutData((Object)data);
            for (Property property : contextElement.getProperties()) {
                Label label = new Label(this.fields, 0);
                label.setText(property.getName());
                TernaryButton showSingle = new TernaryButton(this.fields, this.getGenerator().isSelectedSingle(property));
                TernaryButton showMultiple = new TernaryButton(this.fields, this.getGenerator().isSelectedMultiple(property));
                PropertyDefinition propertyDefinition = this.getWizard().getPropertyDefinition(this.fieldSelection, property);
                IObservableValue singleValue = EMFProperties.value((EStructuralFeature)FieldSelectionPackage.eINSTANCE.getPropertyDefinition_ValueSingle()).observe((Object)propertyDefinition);
                IObservableValue multipleValue = EMFProperties.value((EStructuralFeature)FieldSelectionPackage.eINSTANCE.getPropertyDefinition_ValueMultiple()).observe((Object)propertyDefinition);
                showSingle.setObservable(singleValue);
                showMultiple.setObservable(multipleValue);
                Label description = new Label(this.fields, 64);
                String propertyDescription = "";
                if (propertyDescription == null || propertyDescription.trim().equals("")) {
                    propertyDescription = Messages.SelectFieldsPage_descriptionNotAvailable;
                    description.setAlignment(0x1000000);
                }
                description.setText(propertyDescription);
                data = new GridData(4, 0x1000000, true, false);
                label.setLayoutData((Object)data);
                data = new GridData(4, 0x1000000, true, false);
                showSingle.setLayoutData(data);
                data = new GridData(4, 0x1000000, true, false);
                showMultiple.setLayoutData(data);
                data = new GridData(0x1000000, 0x1000000, true, false);
                data.widthHint = 500;
                description.setLayoutData((Object)data);
            }
        }
        if (contextElement instanceof DataContextPackage) {
            DataContextPackage contextPackage = (DataContextPackage)contextElement;
            for (DataContextElement element : contextPackage.getElements()) {
                this.displayFields(element);
            }
        }
    }

    private IGenerator getGenerator() {
        return this.getWizard().generator;
    }

    public void setTargetURI(URI uri) {
        this.targetURI = uri;
    }

    public void setVisible(boolean visible) {
        super.setPageComplete(true);
        super.setVisible(visible);
        if (this.contexts == null && visible) {
            this.setContexts(this.getWizard().generator.generate(this.targetURI));
        }
    }

    public FieldSelection getFieldSelection() {
        return this.fieldSelection;
    }
}

