/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard.widget;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.ExtensionFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileChooser
extends Composite
implements SelectionListener,
Listener {
    private Text text;
    private Button browse;
    private IFile currentFile;
    private List<ViewerFilter> filters;
    private Set<Listener> listeners = new HashSet<Listener>();
    private boolean newFile;

    public FileChooser(Composite parent, boolean newFile) {
        super(parent, 0);
        this.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text.addListener(16, (Listener)this);
        this.browse = new Button((Composite)this, 8);
        this.browse.setText(Messages.FileChooser_browseWorkspace);
        this.browse.addSelectionListener((SelectionListener)this);
        this.filters = new LinkedList<ViewerFilter>();
        this.newFile = newFile;
    }

    public String getFilePath() {
        String path = this.text.getText();
        if (path.trim().equals("")) {
            return null;
        }
        return path.trim();
    }

    public void setFilterExtensions(String[] extensions) {
        this.filters.clear();
        ExtensionFilter filter = new ExtensionFilter(extensions);
        this.filters.add(filter);
    }

    public void handleEvent(Event event) {
        this.notifyChange();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        IFile[] result = new IFile[]{};
        if (this.newFile) {
            IFile file = WorkspaceResourceDialog.openNewFile((Shell)this.getShell(), null, null, null, this.filters);
            if (file != null) {
                result = new IFile[]{file};
            }
        } else {
            result = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, null, (boolean)false, (Object[])new Object[]{this.currentFile}, this.filters);
        }
        if (result.length >= 1) {
            this.currentFile = result[0];
            this.text.setText(this.currentFile.getFullPath().toString());
            this.notifyChange();
        }
    }

    private void notifyChange() {
        for (Listener listener : this.listeners) {
            listener.handleEvent(null);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

