/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.editor.MoDiscoDropAdapter;
import org.eclipse.papyrus.customization.properties.editor.ViewFilter;
import org.eclipse.papyrus.customization.properties.editor.preview.Preview;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.customization.properties.providers.ContextContentProvider;
import org.eclipse.papyrus.customization.properties.providers.ContextLabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.widgets.layout.GridData;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class UIEditor
extends EcoreEditor
implements ITabbedPropertySheetPageContributor,
CommandStackListener {
    private Set<Preview> previews = new HashSet<Preview>();
    private TreeViewer selectionViewer;
    protected IPropertySheetPage iPropertySheetPage;

    public void createPages() {
        this.createModel();
        this.getContainer().setBackground(this.getContainer().getDisplay().getSystemColor(1));
        this.getContainer().setBackgroundMode(1);
        Composite gParent = new Composite(this.getContainer(), 0);
        gParent.setLayout((Layout)new FillLayout());
        Composite parent = new Composite(gParent, 0);
        parent.setLayout((Layout)new PropertiesLayout());
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            final ViewFilter filter = new ViewFilter();
            final StringEditor filterPattern = new StringEditor(parent, 0, Messages.UIEditor_FilterViews);
            filterPattern.addCommitListener(new ICommitListener(){

                public void commit(AbstractEditor editor) {
                    filter.setPattern((String)filterPattern.getValue());
                    UIEditor.this.selectionViewer.refresh();
                }
            });
            Tree tree = new Tree(parent, 2050);
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            this.selectionViewer = new TreeViewer(tree);
            this.selectionViewer.setFilters(new ViewerFilter[]{filter});
            this.setCurrentViewer((Viewer)this.selectionViewer);
            ContextContentProvider contentProvider = new ContextContentProvider();
            contentProvider.getCustomizationManager().installCustomPainter(tree);
            ContextLabelProvider labelProvider = new ContextLabelProvider();
            this.editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
            this.selectionViewer.setContentProvider((IContentProvider)contentProvider);
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)gParent);
            this.setPageText(pageIndex, "Model");
            this.setActivePage(0);
            parent.layout();
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    UIEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.updateProblemIndication();
        this.changePerspective();
        this.getEditingDomain().getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)new PropertiesURIHandler());
    }

    protected void changePerspective() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return;
        }
        IPerspectiveDescriptor descriptor = activePage.getPerspective();
        if (descriptor.getId().equals("org.eclipse.papyrus.customization.properties.perspective")) {
            return;
        }
        boolean openPerspective = false;
        if (openPerspective) {
            try {
                PlatformUI.getWorkbench().showPerspective("org.eclipse.papyrus.customization.properties.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected void createContextMenuForGen(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new MoDiscoDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.refreshContext();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.create();
        saveAsDialog.setMessage(EcoreEditorPlugin.INSTANCE.getString("_UI_SaveAs_message"));
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            Resource currentResource = (Resource)resourceSet.getResources().get(0);
            String currentExtension = currentResource.getURI().fileExtension();
            URI currentURI = currentResource.getURI();
            URI newURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            String newExtension = newURI.fileExtension();
            if (currentExtension.equals("ecore") && newExtension.equals("emof") || currentExtension.equals("emof") && newExtension.equals("ecore")) {
                Resource newResource = resourceSet.createResource(newURI);
                newResource.getContents().addAll((Collection)currentResource.getContents());
                resourceSet.getResources().remove(0);
                resourceSet.getResources().move(0, (Object)newResource);
            } else {
                currentResource.setURI(newURI);
            }
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)modelFile);
            this.setPartName(file.getName());
            Context context = this.getContext();
            if (context != null) {
                EcoreUtil.resolveAll((EObject)context);
                for (Resource resource : currentResource.getResourceSet().getResources()) {
                    if (resource == currentResource || !this.isRelative(currentURI, resource)) continue;
                    URI newResourceURI = resource.getURI().deresolve(currentURI).resolve(newURI);
                    resource.setURI(newResourceURI);
                }
            }
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    private boolean isRelative(URI baseURI, Resource resource) {
        URI resourceURI = resource.getURI();
        URI uri = resourceURI.deresolve(baseURI);
        return uri.isRelative() && !uri.toString().startsWith("..") && !uri.toString().startsWith("/");
    }

    protected Context getContext() {
        EObject object = (EObject)((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0);
        if (object instanceof Context) {
            return (Context)object;
        }
        return null;
    }

    private void refreshContext() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            ConfigurationManager.instance.refresh(file.getLocation().toFile());
        }
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.iPropertySheetPage == null) {
            this.iPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return this.iPropertySheetPage;
    }

    public String getContributorId() {
        return "CustomizationPropertyView";
    }

    public void addPreview(Preview preview) {
        this.previews.add(preview);
        this.selectionViewer.addSelectionChangedListener((ISelectionChangedListener)preview);
        preview.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.currentViewer.getSelection()));
    }

    public void removePreview(Preview preview) {
        this.previews.remove((Object)preview);
        this.selectionViewer.removeSelectionChangedListener((ISelectionChangedListener)preview);
    }

    public void dispose() {
        for (Preview preview : this.previews) {
            this.selectionViewer.removeSelectionChangedListener((ISelectionChangedListener)preview);
        }
        this.previews.clear();
        if (this.iPropertySheetPage != null) {
            this.iPropertySheetPage.dispose();
        }
        super.dispose();
    }

    public void commandStackChanged(EventObject event) {
        this.getViewer().refresh();
        for (Preview preview : this.previews) {
            preview.displayView();
        }
    }
}

