/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor.preview;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.editor.UIEditor;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.views.properties.runtime.DisplayEngine;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preview
extends ViewPart
implements ISelectionChangedListener,
IPartListener {
    private Composite parent;
    private ScrolledComposite scrolledParent;
    private CTabFolder contents;
    private DisplayEngine displayEngine;
    private String selectedTab;
    private boolean enabled = true;
    private View currentView;
    private Label previewTitle;
    private Label previewDisabled;
    private Set<UIEditor> currentEditors = new HashSet<UIEditor>();
    private IWorkbenchPage activePage;

    public Preview() {
    }

    public Preview(UIEditor editor) {
        this.currentEditors.add(editor);
    }

    public void createPartControl(Composite container) {
        this.scrolledParent = new ScrolledComposite(container, 2816);
        this.scrolledParent.getVerticalBar().setIncrement(10);
        this.scrolledParent.setBackground(new Color((Device)this.scrolledParent.getDisplay(), 255, 255, 255));
        this.scrolledParent.setBackgroundMode(1);
        this.scrolledParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parent = new Composite((Composite)this.scrolledParent, 0);
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.scrolledParent.setContent((Control)this.parent);
        Composite controls = new Composite(this.parent, 0);
        controls.setLayout((Layout)new GridLayout(5, false));
        controls.setLayoutData((Object)new GridData(4, 4, true, false));
        this.previewTitle = new Label(controls, 0);
        GridData data = new GridData(0x1000000, 1, false, false);
        this.previewTitle.setLayoutData((Object)data);
        this.previewDisabled = new Label(this.parent, 0);
        this.previewDisabled.setLayoutData((Object)new GridData(4, 4, true, false));
        this.contents = new CTabFolder(this.parent, 512);
        if (this.currentEditors.isEmpty()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                this.activePage = window.getActivePage();
                if (this.activePage != null) {
                    IEditorPart editorPart = this.activePage.getActiveEditor();
                    if (editorPart instanceof UIEditor) {
                        this.setEditor((UIEditor)editorPart);
                    }
                    this.activePage.addPartListener((IPartListener)this);
                } else {
                    Activator.log.warn("There is no active page");
                }
            } else {
                Activator.log.warn("There is no current window");
            }
        }
        this.displayView();
    }

    public void setEditor(UIEditor editor) {
        editor.addPreview(this);
        this.currentEditors.add(editor);
    }

    private void refreshDisplay() {
        Point size = this.parent.computeSize(-1, -1);
        if (this.scrolledParent.getSize().x > 0) {
            size.x = this.scrolledParent.getSize().x - 30;
        }
        this.parent.setSize(size);
    }

    private URL saveTmp(Section section) {
        HashMap<String, Boolean> options;
        FileOutputStream os;
        File xwtFile;
        block6: {
            if (section.getSectionFile() == null || section.getWidget() == null) {
                return null;
            }
            IPath path = Activator.getDefault().getPreferencesPath();
            path = path.append("/preview/");
            try {
                File previewDirectory = path.toFile();
                if (!previewDirectory.exists()) {
                    previewDirectory.mkdirs();
                }
                if (!(xwtFile = path.append(section.getSectionFile()).toFile()).exists()) {
                    xwtFile.getParentFile().mkdirs();
                    xwtFile.createNewFile();
                }
                os = new FileOutputStream(xwtFile);
                options = new HashMap<String, Boolean>();
                options.put("format", false);
                if (section.getWidget() != null && section.getWidget().eResource() != null) break block6;
                return null;
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
                return null;
            }
        }
        section.getWidget().eResource().save((OutputStream)os, options);
        return xwtFile.toURI().toURL();
    }

    public void setView(View view) {
        this.currentView = view;
        if (view != null) {
            if (view.getName() == null) {
                this.previewTitle.setText(Messages.Preview_Unnamed);
            } else {
                this.previewTitle.setText(view.getName());
            }
        } else {
            this.previewTitle.setText("");
        }
        this.previewTitle.getParent().layout();
        this.displayView();
    }

    private void setPreviewError(String message) {
        if (message != null) {
            this.previewDisabled.setText(message);
            this.previewDisabled.setVisible(true);
        } else {
            this.previewDisabled.setVisible(false);
        }
        this.refreshDisplay();
    }

    public void displayView() {
        this.contents.dispose();
        if (!this.enabled) {
            this.setPreviewError(Messages.Preview_previewIsDisabled);
            return;
        }
        if (this.currentView == null) {
            this.setPreviewError(Messages.Preview_noSelectedView);
            return;
        }
        this.setPreviewError(null);
        this.displayEngine = new DefaultDisplayEngine();
        HashMap<Tab, Composite> tabs = new HashMap<Tab, Composite>();
        this.contents = new CTabFolder(this.parent, 0);
        this.contents.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean activeTab = false;
        for (Tab tab : this.getTabs(this.currentView)) {
            CTabItem tabItem = new CTabItem(this.contents, 0);
            tabItem.setText(tab.getLabel());
            if (tab.getLabel().equals(this.selectedTab) || !activeTab) {
                this.contents.setSelection(tabItem);
                activeTab = true;
            }
            Composite tabControl = new Composite((Composite)this.contents, 0);
            tabControl.setLayout((Layout)new PropertiesLayout());
            tabItem.setControl((Control)tabControl);
            tabs.put(tab, tabControl);
            tabControl.setEnabled(false);
            this.contents.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Preview.this.selectedTab = Preview.this.contents.getSelection().getText();
                }
            });
        }
        for (Section section : this.currentView.getSections()) {
            Composite tabControl = (Composite)tabs.get(section.getTab());
            Composite pView = new Composite(tabControl, 0);
            pView.setLayout((Layout)new GridLayout(1, false));
            URL sectionURL = this.saveTmp(section);
            if (sectionURL == null) continue;
            this.displayEngine.createSection(pView, section, sectionURL, null);
        }
        this.refreshDisplay();
    }

    private Collection<Tab> getTabs(View view) {
        LinkedList<Tab> tabs = new LinkedList<Tab>();
        for (Section section : view.getSections()) {
            Tab tab = section.getTab();
            if (tab == null || tabs.contains(tab)) continue;
            tabs.add(tab);
        }
        Collections.sort(tabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab tab1, Tab tab2) {
                Tab afterTab1 = tab1.getAfterTab();
                Tab afterTab2 = tab2.getAfterTab();
                if (Preview.this.isAfter(tab1, afterTab2, new HashSet())) {
                    return -1;
                }
                if (Preview.this.isAfter(tab2, afterTab1, new HashSet())) {
                    return 1;
                }
                return 0;
            }
        });
        return tabs;
    }

    private boolean isAfter(Tab tab1, Tab tab2, Set<Tab> checkedTabs) {
        if (checkedTabs.contains(tab2)) {
            Activator.log.warn("Loop in the afterTabs");
            return false;
        }
        checkedTabs.add(tab2);
        if (tab2 == null) {
            return false;
        }
        if (tab1.equals(tab2)) {
            return true;
        }
        return this.isAfter(tab1, tab2.getAfterTab(), checkedTabs);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            ITreeElement child = null;
            ITreeElement element = (ITreeElement)selection.getFirstElement();
            do {
                EObject adapter;
                if (!(element instanceof IAdaptable) || !((adapter = (EObject)((IAdaptable)element).getAdapter(EObject.class)) instanceof View)) continue;
                this.setView((View)adapter);
                return;
            } while ((child = element) != (element = element.getTreeParent()) && element != null);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof UIEditor) {
            this.setEditor((UIEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void dispose() {
        for (UIEditor editor : this.currentEditors) {
            editor.removePreview(this);
        }
        if (this.activePage != null) {
            this.activePage.removePartListener((IPartListener)this);
        }
        super.dispose();
    }
}

