/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;

public class DirectEditorRegistry {
    protected TreeMap<Integer, ArrayList<DirectEditorExtensionPoint>> editorMap = new TreeMap();
    protected ArrayList<String> objectToEdits = new ArrayList();

    public void add(DirectEditorExtensionPoint directEditor) {
        ArrayList<DirectEditorExtensionPoint> currentValue;
        assert (directEditor != null);
        this.objectToEdits.add(directEditor.getObjectToEdit());
        Integer priority = directEditor.getPriority();
        String preferedLanguage = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + directEditor.getObjectToEdit());
        if (preferedLanguage.equals(directEditor.getLanguage())) {
            priority = new Integer(0);
        }
        if ((currentValue = this.editorMap.get(priority)) == null) {
            currentValue = new ArrayList();
        }
        currentValue.add(directEditor);
        this.editorMap.put(priority, currentValue);
    }

    protected void adaptPreferences() {
        Iterator<String> iter = this.objectToEdits.iterator();
        DirectEditorExtensionPoint defaultDirectEditor = null;
        while (iter.hasNext()) {
            String objectToEdit = iter.next();
            defaultDirectEditor = this.getDefaultDirectEditor(objectToEdit);
            String id = "papyrus.directeditor." + defaultDirectEditor.getObjectToEdit();
            String language = defaultDirectEditor.getLanguage();
            Activator.getDefault().getPreferenceStore().setValue(id, language);
        }
    }

    public String toString() {
        String out = "";
        for (Integer index : this.editorMap.keySet()) {
            out = String.valueOf(out) + "\n[" + index + "]" + "=[" + this.editorMap.get(index) + "]";
        }
        return out;
    }

    public void init(DirectEditorExtensionPoint[] directEditors) {
        this.editorMap = new TreeMap();
        this.objectToEdits = new ArrayList();
        int i = 0;
        while (i < directEditors.length) {
            this.add(directEditors[i]);
            ++i;
        }
        this.adaptPreferences();
    }

    public DirectEditorExtensionPoint getDefaultDirectEditor(String ObjectToEdit) {
        for (Integer index : this.editorMap.keySet()) {
            for (DirectEditorExtensionPoint directEditorExtensionPoint : this.editorMap.get(index)) {
                if (!directEditorExtensionPoint.getObjectToEdit().equals(ObjectToEdit)) continue;
                return directEditorExtensionPoint;
            }
        }
        return null;
    }
}

