/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorExtensionPoint;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusEmbeddedEditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    protected static final String DEFAULT_EDITOR_LABEL = " (Default Editor)";
    private static final String DATA_EDITOR = "editor";
    protected Table elementTypeTable;
    protected Table editorTable;
    protected Button defaultEditorButton;
    protected Label editorLabel;
    protected IWorkbench workbench;
    protected List<Image> imagesToDispose;
    protected Map<IEditorDescriptor, Image> editorsToImages;

    protected Control createContents(Composite parent) {
        this.imagesToDispose = new ArrayList<Image>();
        this.editorsToImages = new HashMap<IEditorDescriptor, Image>(50);
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        Label label = new Label(pageComponent, 16384);
        label.setText("Elements to edit");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.elementTypeTable = new Table(pageComponent, 67588);
        this.elementTypeTable.addListener(13, (Listener)this);
        this.elementTypeTable.addListener(14, (Listener)this);
        data = new GridData(768);
        data.horizontalAlignment = 4;
        data.heightHint = this.elementTypeTable.getItemHeight() * 10;
        this.elementTypeTable.setLayoutData((Object)data);
        Composite groupComponent = new Composite(pageComponent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        label = new Label(pageComponent, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.editorLabel = new Label(pageComponent, 16384);
        this.editorLabel.setText("Associated editor");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.editorLabel.setLayoutData((Object)data);
        this.editorTable = new Table(pageComponent, 2052);
        this.editorTable.addListener(13, (Listener)this);
        this.editorTable.addListener(14, (Listener)this);
        data = new GridData(1808);
        data.heightHint = this.editorTable.getItemHeight() * 7;
        this.editorTable.setLayoutData((Object)data);
        groupComponent = new Composite(pageComponent, 0);
        groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.defaultEditorButton = new Button(groupComponent, 8);
        this.defaultEditorButton.setText("Default");
        this.defaultEditorButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.defaultEditorButton);
        this.fillResourceTypeTable();
        if (this.elementTypeTable.getItemCount() > 0) {
            this.elementTypeTable.setSelection(0);
        }
        this.fillEditorTable();
        this.updateEnabledState();
        this.applyDialogFont(pageComponent);
        return pageComponent;
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null) {
            for (Image image2 : this.imagesToDispose) {
                image2.dispose();
            }
            this.imagesToDispose = null;
        }
        if (this.editorsToImages != null) {
            for (Image image2 : this.editorsToImages.values()) {
                image2.dispose();
            }
            this.editorsToImages = null;
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void fillEditorTable() {
        this.editorTable.removeAll();
        String elementType = this.getSelectedElementType();
        String preferedLanguage = this.getPreferenceStore().getString("papyrus.directeditor." + elementType);
        boolean simpleEditorPrefered = "Simple Direct Editor".equals(preferedLanguage);
        List<DirectEditorExtensionPoint> editors = this.getAssociatedEditors();
        for (DirectEditorExtensionPoint extensionPoint : editors) {
            TableItem item = new TableItem(this.editorTable, 0);
            item.setData(DATA_EDITOR, (Object)extensionPoint);
            String label = this.getEditorItemName(extensionPoint);
            if (preferedLanguage.equals(extensionPoint.getLanguage())) {
                label = String.valueOf(label) + DEFAULT_EDITOR_LABEL;
            }
            item.setText(label);
        }
        TableItem item = new TableItem(this.editorTable, 0);
        item.setData(DATA_EDITOR, null);
        item.setText(simpleEditorPrefered ? String.valueOf(this.getEditorItemName(null)) + DEFAULT_EDITOR_LABEL : this.getEditorItemName(null));
    }

    public String getEditorItemName(DirectEditorExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            return "Simple Direct Editor";
        }
        return extensionPoint.getLanguage();
    }

    protected void fillResourceTypeTable() {
        HashMap elements = new HashMap();
        DirectEditorExtensionPoint[] extensionPoints = DirectEditorExtensionPoint.getDirectEditorConfigurations();
        DirectEditorExtensionPoint[] directEditorExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            DirectEditorExtensionPoint extensionPoint = directEditorExtensionPointArray[n2];
            List<DirectEditorExtensionPoint> configurations = !elements.containsKey(extensionPoint.getObjectToEdit()) ? new ArrayList<DirectEditorExtensionPoint>() : (List)elements.get(extensionPoint.getObjectToEdit());
            configurations.add(extensionPoint);
            elements.put(extensionPoint.getObjectToEdit(), configurations);
            ++n2;
        }
        Set keys = elements.keySet();
        int i = 0;
        for (String key : keys) {
            this.newElementTypeTableItem((List)elements.get(key), i, false);
            ++i;
        }
    }

    protected Image getImage(IEditorDescriptor editor) {
        Image image = this.editorsToImages.get(editor);
        if (image == null) {
            image = editor.getImageDescriptor().createImage();
            this.editorsToImages.put(editor, image);
        }
        return image;
    }

    protected String getSelectedElementType() {
        TableItem[] items = this.elementTypeTable.getSelection();
        if (items.length > 0) {
            return items[0].getText();
        }
        return null;
    }

    protected List<DirectEditorExtensionPoint> getAssociatedEditors() {
        if (this.getSelectedElementType() == null) {
            return null;
        }
        TableItem[] items = this.elementTypeTable.getSelection();
        if (items.length > 0) {
            return (List)items[0].getData();
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.defaultEditorButton) {
            this.setSelectedEditorAsDefault();
        } else if (event.widget == this.elementTypeTable) {
            this.fillEditorTable();
        }
        this.updateEnabledState();
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        this.noDefaultAndApplyButton();
    }

    protected TableItem newElementTypeTableItem(List<DirectEditorExtensionPoint> configurations, int index, boolean selected) {
        TableItem item = new TableItem(this.elementTypeTable, 0, index);
        item.setText(configurations.get(0).getObjectToEdit());
        item.setData(configurations);
        if (selected) {
            this.elementTypeTable.setSelection(index);
        }
        return item;
    }

    public boolean performOk() {
        return super.performOk();
    }

    public void setSelectedEditorAsDefault() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.editorTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().endsWith(DEFAULT_EDITOR_LABEL)) {
                DirectEditorExtensionPoint oldExtensionPoint = (DirectEditorExtensionPoint)item.getData(DATA_EDITOR);
                item.setText(oldExtensionPoint != null ? oldExtensionPoint.getLanguage() : "Simple Direct Editor");
            }
            ++n2;
        }
        TableItem[] selectedItems = this.editorTable.getSelection();
        if (selectedItems.length > 0) {
            DirectEditorExtensionPoint extensionPoint = (DirectEditorExtensionPoint)selectedItems[0].getData(DATA_EDITOR);
            selectedItems[0].setText(String.valueOf(selectedItems[0].getText()) + DEFAULT_EDITOR_LABEL);
            this.getPreferenceStore().setValue("papyrus.directeditor." + this.getSelectedElementType(), extensionPoint != null ? extensionPoint.getLanguage() : "Simple Direct Editor");
        }
    }

    public TableItem getDefaultItem() {
        return null;
    }

    public void updateEnabledState() {
        boolean resourceTypeSelected = this.elementTypeTable.getSelectionIndex() != -1;
        boolean editorSelected = this.editorTable.getSelectionIndex() != -1;
        this.editorLabel.setEnabled(resourceTypeSelected);
        this.defaultEditorButton.setEnabled(editorSelected);
    }

    public void updateSelectedResourceType() {
    }
}

