/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.papyrus.extensionpoints.editors.ui.EmbeddedEditorInput;
import org.eclipse.papyrus.extensionpoints.editors.ui.EmbeddedTextEditor;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class EmbeddedEditorDocumentProvider
extends AbstractDocumentProvider {
    protected EmbeddedTextEditor textEditor;

    public EmbeddedEditorDocumentProvider(EmbeddedTextEditor textEditor) {
        this.textEditor = textEditor;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        Document result = new Document();
        result.set(this.getLabelToEdit(element));
        return result;
    }

    public boolean isModifiable(Object element) {
        return true;
    }

    protected String getLabelToEdit(Object element) {
        if (element instanceof EmbeddedEditorInput) {
            EObject object = ((EmbeddedEditorInput)((Object)element)).getEditedObject();
            return this.textEditor.getDirectEditorConfiguration().getTextToEdit(object);
        }
        return element.toString();
    }

    protected Object applyChanges(Object element) {
        if (element instanceof EmbeddedEditorInput) {
            EObject object = ((EmbeddedEditorInput)((Object)element)).getEditedObject();
            return this.textEditor.getDirectEditorConfiguration().postEditAction(object, this.getDocument((Object)((EmbeddedEditorInput)((Object)element))).get());
        }
        return element.toString();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        throw new RuntimeException("Impossible to save the content of an embedded editor.");
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

