/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.OCLModelQuery;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.ConfigProperty;
import org.eclipse.papyrus.infra.constraints.ReferenceProperty;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class EMFQueryConstraint
extends AbstractConstraint {
    private OCLModelQuery query;

    protected void setDescriptor(SimpleConstraint descriptor) {
        ConfigProperty property = this.getProperty("query");
        if (!(property instanceof ReferenceProperty)) {
            String queryExpression = ((ValueProperty)property).getValue();
            this.query = QueryFactory.eINSTANCE.createOCLModelQuery();
            this.query.setQuery(queryExpression);
            this.query.setReturnType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
            this.query.getScope().add((Object)EcorePackage.eINSTANCE.getEObject());
            throw new UnsupportedOperationException();
        }
        this.query = (OCLModelQuery)this.getReferenceValue("query");
    }

    public boolean match(Object selection) {
        if (this.query == null) {
            return false;
        }
        EObject selectedItem = EMFHelper.getEObject((Object)selection);
        if (selectedItem != null) {
            try {
                ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
                AbstractModelQuery abstractQuery = catalog.getModelQueryImpl((ModelQuery)this.query);
                ModelQueryResult result = abstractQuery.evaluate(selectedItem);
                Object value = result.getValue();
                return value == null ? false : (Boolean)value;
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return false;
    }

    protected boolean equivalent(Constraint constraint) {
        if (constraint != null && constraint instanceof EMFQueryConstraint) {
            EMFQueryConstraint other = (EMFQueryConstraint)constraint;
            return other.query.equals(this.query);
        }
        return false;
    }
}

