/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.constraints.JavaQuery;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class JavaQueryConstraint
extends AbstractConstraint {
    public static final String QUERY_CLASS_NAME_PROPERTY = "className";
    private JavaQuery query = new JavaQuery.FalseQuery();

    protected void setDescriptor(ConstraintDescriptor descriptor) {
        String queryClassName = this.getValue(QUERY_CLASS_NAME_PROPERTY);
        this.query = (JavaQuery)ClassLoaderHelper.newInstance((String)queryClassName, JavaQuery.class);
        if (this.query == null) {
            Activator.log.warn("Cannot load the JavaQuery for this constraint : " + descriptor.getName());
        }
    }

    public boolean match(Object selection) {
        return this.query.match(selection);
    }

    protected boolean equivalent(Constraint constraint) {
        if (constraint instanceof JavaQueryConstraint) {
            return ((JavaQueryConstraint)constraint).query.getClass().equals(this.query.getClass());
        }
        return false;
    }
}

