/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers.strategy;

import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyBasedContentProvider
extends EncapsulatedContentProvider {
    protected TreeBrowseStrategy browseStrategy;
    protected TreeBrowseStrategy revealStrategy;
    protected StructuredViewer viewer;

    public StrategyBasedContentProvider(TreeBrowseStrategy browseStrategy, TreeBrowseStrategy revealStrategy) {
        this.setRevealStrategy(revealStrategy);
        this.setBrowseStrategy(browseStrategy);
    }

    public void setBrowseStrategy(TreeBrowseStrategy strategy) {
        if (strategy != null) {
            this.browseStrategy = strategy;
            this.encapsulated = this.browseStrategy;
        }
    }

    public void setRevealStrategy(TreeBrowseStrategy strategy) {
        if (strategy != null) {
            this.revealStrategy = strategy;
        }
    }

    public void dispose() {
        super.dispose();
        this.browseStrategy = null;
        this.revealStrategy = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer instanceof StructuredViewer ? (StructuredViewer)viewer : null;
        this.revealStrategy.inputChanged(viewer, oldInput, newInput);
        this.browseStrategy.inputChanged(viewer, oldInput, newInput);
    }

    public void revealSemanticElement(List<?> semanticElementsList) {
        this.revealStrategy.revealSemanticElement(semanticElementsList);
    }

    public TreeBrowseStrategy getBrowseStrategy() {
        return this.browseStrategy;
    }

    public TreeBrowseStrategy getRevealStrategy() {
        return this.revealStrategy;
    }
}

