/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.export.Messages;
import org.eclipse.papyrus.infra.export.internal.Activator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAllDiagrams {
    private IFile file;
    private String extension;
    private String outputDirectoryPath;
    private IWorkbenchWindow workbenchWindow;
    private boolean displayRenamingInformation;
    private static boolean useDisplayRunnable = true;
    private boolean qualifiedName;
    private BasicDiagnostic diagnostic = new BasicDiagnostic(0, "", 0, Messages.ExportAllDiagrams_18, null);

    public ExportAllDiagrams(IFile file, String outputDirectoryPath, String extension, boolean qualifiedName) {
        this.file = file;
        this.extension = extension;
        this.outputDirectoryPath = outputDirectoryPath;
        try {
            this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (IllegalStateException e) {
            this.workbenchWindow = null;
        }
        this.displayRenamingInformation = true;
        this.qualifiedName = qualifiedName;
    }

    public void exportDiagramsToImages() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                IProgressMonitor newMonitor = monitor;
                ExportAllDiagrams.this.export(newMonitor);
            }
        };
        Job job = new Job(Messages.ExportAllDiagrams_0, (IRunnableWithProgress)op){
            private final /* synthetic */ IRunnableWithProgress val$op;
            {
                this.val$op = iRunnableWithProgress;
                super($anonymous0);
            }

            public IStatus run(IProgressMonitor monitor) {
                try {
                    this.val$op.run(monitor);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void export(IProgressMonitor newMonitor) {
        newMonitor.beginTask(Messages.ExportAllDiagrams_1, 10);
        newMonitor.subTask(Messages.ExportAllDiagrams_2);
        if (this.file != null) {
            final ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            resourceSet.getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true), true);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
            if (editingDomain == null) {
                TransactionalEditingDomain.Factory factory = TransactionalEditingDomain.Factory.INSTANCE;
                editingDomain = factory.createEditingDomain((ResourceSet)resourceSet);
            }
            AbstractTransactionalCommand com = new AbstractTransactionalCommand(editingDomain, "Resolve", Collections.emptyList()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EcoreUtil.resolveAll((ResourceSet)resourceSet);
                    return null;
                }
            };
            CommandStack commandStack = editingDomain.getCommandStack();
            if (commandStack instanceof TransactionalCommandStack) {
                TransactionalCommandStack stack = (TransactionalCommandStack)commandStack;
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("silent", Boolean.TRUE);
                options.put("no_undo", Boolean.TRUE);
                options.put("unprotected", Boolean.TRUE);
                options.put("is_undo_redo_transaction", Boolean.FALSE);
                options.put("no_triggers", Boolean.TRUE);
                options.put("validate_edit", Boolean.FALSE);
                options.put("validate_edit_context", Boolean.FALSE);
                try {
                    stack.execute((Command)new GMFtoEMFCommandWrapper((ICommand)com), options);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (RollbackException rollbackException) {}
            } else {
                Activator.log("no transactional editing domain found", 2);
            }
            ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
            if (newMonitor.isCanceled()) {
                return;
            }
            TreeIterator i = resourceSet.getAllContents();
            while (i.hasNext()) {
                Notifier n = (Notifier)i.next();
                if (!(n instanceof Diagram)) continue;
                diagrams.add((Diagram)n);
            }
            if (newMonitor.isCanceled()) {
                return;
            }
            newMonitor.worked(1);
            this.export((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
        } else {
            Activator.log((IStatus)new Status(4, "org.eclipse.papyrus.infra.export", Messages.ExportAllDiagrams_3));
        }
    }

    public void export(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        BasicDiagnostic oldDiagnostic;
        int severity;
        newMonitor.beginTask(Messages.ExportAllDiagrams_4, 10);
        boolean duplicates = this.createDiagramFiles((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
        this.unloadResources((IProgressMonitor)new SubProgressMonitor(newMonitor, 1), diagrams);
        if (duplicates && this.displayRenamingInformation) {
            String message = Messages.ExportAllDiagrams_5;
            if (this.workbenchWindow != null && this.workbenchWindow.getShell() != null) {
                BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, message, null);
                this.diagnostic.add((Diagnostic)newDiagnostic);
            } else {
                Activator.log((IStatus)new Status(1, "org.eclipse.papyrus.infra.export", message));
            }
        }
        if ((severity = this.diagnostic.recomputeSeverity()) == 4) {
            oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(4, "", 0, Messages.ExportAllDiagrams_22, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        } else if (severity == 2) {
            oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(2, "", 0, Messages.ExportAllDiagrams_24, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        } else if (severity == 0 && this.workbenchWindow != null && this.workbenchWindow.getShell() != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Activator.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_25, (String)(String.valueOf(Messages.ExportAllDiagrams_26) + ExportAllDiagrams.this.outputDirectoryPath));
                }
            });
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                DiagnosticDialog.open((Shell)Activator.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_27, (String)"", (Diagnostic)ExportAllDiagrams.this.diagnostic);
            }
        });
    }

    private boolean createDiagramFiles(final IProgressMonitor newMonitor, List<Diagram> diagrams) {
        boolean duplicates = false;
        boolean nameCut = false;
        try {
            ArrayList<String> diagramNames = new ArrayList<String>();
            try {
                newMonitor.beginTask(Messages.ExportAllDiagrams_7, diagrams.size());
                for (final Diagram diagram : diagrams) {
                    if (!newMonitor.isCanceled()) {
                        String uniqueFileName;
                        String label = "";
                        if (this.qualifiedName) {
                            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                            composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
                            IItemLabelProvider itemLabelFactory = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)diagram.getElement(), IItemLabelProvider.class);
                            label = String.valueOf(itemLabelFactory.getText((Object)diagram.getElement()).replace(Messages.ExportAllDiagrams_16, "")) + "_";
                        }
                        if ((uniqueFileName = this.encodeFileName(String.valueOf(label) + diagram.getName())).length() > 150) {
                            nameCut = true;
                            uniqueFileName = uniqueFileName.substring(0, 150);
                        }
                        if (diagramNames.contains(uniqueFileName)) {
                            duplicates = true;
                            uniqueFileName = this.getFirstAvailableName(uniqueFileName, diagramNames, 1);
                        }
                        if (nameCut) {
                            BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, String.valueOf(Messages.ExportAllDiagrams_10) + uniqueFileName, null);
                            this.diagnostic.add((Diagnostic)newDiagnostic);
                            nameCut = false;
                        }
                        final String finalUniqueFileName = uniqueFileName;
                        diagramNames.add(uniqueFileName);
                        newMonitor.subTask(String.valueOf(Messages.ExportAllDiagrams_8) + uniqueFileName);
                        if (useDisplayRunnable) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    ExportAllDiagrams.this.exportDiagram(finalUniqueFileName, diagram, newMonitor);
                                }
                            });
                        } else {
                            this.exportDiagram(uniqueFileName, diagram, newMonitor);
                        }
                        newMonitor.worked(1);
                        continue;
                    }
                    break;
                }
            }
            catch (SWTError e) {
                String message = Messages.ExportAllDiagrams_9;
                Activator.log(new Exception(message, e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicates;
    }

    private void exportDiagram(String uniqueFileName, Diagram diagram, IProgressMonitor newMonitor) {
        CopyToImageUtil copyImageUtil = new CopyToImageUtil();
        try {
            copyImageUtil.copyToImage(diagram, (IPath)new Path(String.valueOf(this.outputDirectoryPath) + File.separator + uniqueFileName + "." + ImageFileFormat.resolveImageFormat((String)this.extension)), ImageFileFormat.resolveImageFormat((String)this.extension), (IProgressMonitor)new SubProgressMonitor(newMonitor, 1), PreferencesHint.USE_DEFAULTS);
        }
        catch (Throwable e) {
            BasicDiagnostic newDiagnostic = new BasicDiagnostic(4, "", 0, String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString()), null);
            this.diagnostic.add((Diagnostic)newDiagnostic);
            Activator.log(String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString()), 4, e);
        }
    }

    public void unloadResources(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        if (newMonitor == null) {
            newMonitor = new NullProgressMonitor();
        }
        newMonitor.subTask(Messages.ExportAllDiagrams_12);
        if (diagrams != null && !diagrams.isEmpty()) {
            ResourceSet resourceSet2 = diagrams.get(0).eResource().getResourceSet();
            newMonitor.beginTask(Messages.ExportAllDiagrams_13, resourceSet2.getResources().size());
            int i = resourceSet2.getResources().size() - 1;
            while (i >= 0) {
                try {
                    Resource r = (Resource)resourceSet2.getResources().get(i);
                    if (r.isLoaded()) {
                        r.unload();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                newMonitor.worked(1);
                --i;
            }
        }
    }

    private String encodeFileName(String pathName) {
        pathName = pathName.trim();
        pathName = pathName.replaceAll(Messages.ExportAllDiagrams_14, Messages.ExportAllDiagrams_15);
        pathName = pathName.replaceAll("_-_", "-");
        while (pathName.contains("__")) {
            pathName = pathName.replaceAll("__", "_");
        }
        if (pathName.startsWith("_")) {
            pathName = pathName.replaceFirst("_", "");
        }
        if (pathName.endsWith("_")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        return pathName;
    }

    private String getFirstAvailableName(String commonBasis, List<String> existingNames, int cpt) {
        if (existingNames.contains(String.valueOf(commonBasis) + cpt)) {
            return this.getFirstAvailableName(commonBasis, existingNames, cpt + 1);
        }
        return String.valueOf(commonBasis) + cpt;
    }
}

