/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.policy;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultActionHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.DropStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DefaultDropStrategy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableDropEditPolicy
extends DragDropEditPolicy {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.dnd.dropStrategy";
    protected EditPolicy defaultDropEditPolicy;
    protected EditPolicy defaultCreationEditPolicy;
    protected DropStrategy defaultDropStrategy;
    public static final String EVENT_DETAIL = "EVENT_DETAIL";

    public void activate() {
    }

    public CustomizableDropEditPolicy(EditPolicy defaultDropEditPolicy, EditPolicy defaultCreationEditPolicy) {
        this.defaultDropEditPolicy = defaultDropEditPolicy;
        this.defaultCreationEditPolicy = defaultCreationEditPolicy;
        this.defaultDropStrategy = new DefaultDropStrategy(defaultDropEditPolicy, defaultCreationEditPolicy);
    }

    public Command getCommand(Request request) {
        Object command;
        if (super.understandsRequest(request)) {
            try {
                command = super.getCommand(request);
            }
            catch (Exception ex) {
                command = this.getCustomCommand(request);
            }
        } else {
            command = this.understands(request) ? this.getCreationCommand(request) : (this.defaultCreationEditPolicy != null ? this.defaultCreationEditPolicy.getCommand(request) : null);
        }
        if (command == null) {
            return null;
        }
        return command;
    }

    public boolean understandsRequest(Request request) {
        return this.understands(request) || this.defaultCreationEditPolicy != null && this.defaultCreationEditPolicy.understandsRequest(request) || this.defaultDropEditPolicy != null && this.defaultDropEditPolicy.understandsRequest(request);
    }

    protected boolean understands(Request request) {
        return "add children".equals(request.getType());
    }

    protected Command getCreationCommand(Request request) {
        return this.getCustomCommand(request);
    }

    protected Command getDropObjectsCommand(DropObjectsRequest request) {
        return this.getCustomCommand((Request)request);
    }

    protected Command getCustomCommand(Request request) {
        final Map<DropStrategy, Command> matchingStrategies = this.findStrategies(request);
        if (matchingStrategies.size() == 1) {
            return matchingStrategies.values().iterator().next();
        }
        if (matchingStrategies.size() > 1) {
            DropStrategy defaultStrategy;
            int eventDetailValue;
            boolean useDefault = true;
            if (request.getExtendedData().containsKey(EVENT_DETAIL) && ((eventDetailValue = ((Integer)request.getExtendedData().get(EVENT_DETAIL)).intValue()) & 1) != 0) {
                useDefault = false;
            }
            if (useDefault && (defaultStrategy = DropStrategyManager.instance.getDefaultDropStrategy(matchingStrategies.keySet())) != null) {
                return matchingStrategies.get(defaultStrategy);
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            DefaultActionHandler handler = new DefaultActionHandler(){

                public void defaultActionSelected(Command defaultCommand) {
                    DropStrategy defaultStrategy = CustomizableDropEditPolicy.findStrategy(matchingStrategies, defaultCommand);
                    if (defaultStrategy != null) {
                        DropStrategyManager.instance.setDefaultDropStrategy(matchingStrategies.keySet(), defaultStrategy);
                    }
                }

                public String getLabel() {
                    return "Change the default strategy";
                }
            };
            SelectAndExecuteCommand command = new SelectAndExecuteCommand("Select drop", shell, new LinkedList<Command>(matchingStrategies.values()), handler);
            return new ICommandProxy((ICommand)command);
        }
        return null;
    }

    private static DropStrategy findStrategy(Map<DropStrategy, Command> matchingStrategies, Command command) {
        for (Map.Entry<DropStrategy, Command> entry : matchingStrategies.entrySet()) {
            if (entry.getValue() != command) continue;
            return entry.getKey();
        }
        return null;
    }

    protected Map<DropStrategy, Command> findStrategies(Request request) {
        LinkedHashMap<DropStrategy, Command> matchingStrategies = new LinkedHashMap<DropStrategy, Command>();
        for (DropStrategy strategy : DropStrategyManager.instance.getActiveStrategies()) {
            Command command = strategy.getCommand(request, this.getHost());
            if (command == null || !command.canExecute()) continue;
            matchingStrategies.put(strategy, command);
        }
        Command command = this.defaultDropStrategy.getCommand(request, this.getHost());
        if (command != null && command.canExecute()) {
            matchingStrategies.put(this.defaultDropStrategy, command);
        }
        return matchingStrategies;
    }

    public void showTargetFeedback(Request request) {
        if (!(this.getHost() instanceof DiagramEditPart)) {
            super.showTargetFeedback(request);
        }
    }
}

