/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.handlers.AbstractDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.modelexplorer.messages.Messages;

public class DuplicateDiagramHandler
extends AbstractDiagramCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        final IPageMngr pageManager = this.getPageManager();
        List<Diagram> diagrams = this.getSelectedDiagrams();
        if (editingDomain != null && pageManager != null && !diagrams.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (Diagram diagram : diagrams) {
                final Diagram newDiagram = (Diagram)EcoreUtil.copy((EObject)diagram);
                newDiagram.setName(NLS.bind((String)Messages.DuplicateDiagramHandler_CopyOf, (Object)diagram.getName()));
                AddCommand addGmfDiagramCmd = new AddCommand((EditingDomain)editingDomain, diagram.eResource().getContents(), (Object)newDiagram);
                RecordingCommand sashOpenComd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        pageManager.openPage((Object)newDiagram);
                    }
                };
                command.append((Command)addGmfDiagramCmd);
                command.append((Command)sashOpenComd);
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

