/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.utils;

import java.util.List;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.navigation.utils.Messages;
import org.eclipse.papyrus.views.modelexplorer.MoDiscoLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDiagramDialog
extends Dialog {
    private List<Diagram> diagrams;
    private Composite dialogComposite;
    protected int selectedDiagram;
    private Table table;
    private TableViewer list;

    public int getSelectedDiagram() {
        return this.selectedDiagram;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MultiDiagramDialog_0);
    }

    public MultiDiagramDialog(Shell parentShell, List<Diagram> diagrams) {
        super(parentShell);
        this.diagrams = diagrams;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogComposite = (Composite)super.createDialogArea(parent);
        parent.setLayout((Layout)new GridLayout());
        this.dialogComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDialogComposite();
        this.createDialogContents(this.dialogComposite);
        this.hookListeners();
        this.loadData();
        this.defaultSelection();
        return this.dialogComposite;
    }

    private void createDialogContents(Composite parent) {
        this.dialogComposite.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDiagrams = new Label(composite, 0);
        lblDiagrams.setText(Messages.MultiDiagramDialog_1);
        Composite composite_1 = new Composite(parent, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        this.list = new TableViewer(composite_1, 68352);
        this.list.setUseHashlookup(true);
        this.table = this.list.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.list.setLabelProvider((IBaseLabelProvider)new MoDiscoLabelProvider());
        this.list.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[]{inputElement};
            }
        });
    }

    private void createDialogComposite() {
        GridData dialogLayoutData = new GridData(1808);
        this.dialogComposite.setLayoutData((Object)dialogLayoutData);
    }

    private void hookListeners() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiDiagramDialog.this.selectedDiagram = MultiDiagramDialog.this.table.getSelectionIndex();
            }
        });
    }

    private void loadData() {
        this.list.setInput(this.diagrams);
    }

    private void defaultSelection() {
        boolean found = false;
        try {
            IPageMngr pageMngr = (IPageMngr)EditorUtils.getServiceRegistry().getService(IPageMngr.class);
            for (Diagram diagram : this.diagrams) {
                if (!pageMngr.isOpen((Object)diagram)) continue;
                this.table.select(this.diagrams.indexOf(diagram));
                found = true;
                break;
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (!found) {
            this.table.select(0);
        }
    }
}

