/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomBooleanStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomEObjectStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomEObjectStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomIntStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomIntStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomStringStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.custom.CustomStringStyleObservableValue;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.creation.StringEditionFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.environment.Type;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;

public class CustomStyleModelElement
extends EMFModelElement {
    private DataContextElement element;
    private View view;

    public CustomStyleModelElement(View source, DataContextElement context) {
        this(source, null, context);
    }

    public CustomStyleModelElement(View source, EditingDomain domain, DataContextElement element) {
        super((EObject)source, domain);
        this.element = element;
        this.view = source;
    }

    protected Property findProperty(String propertyPath) {
        for (Property property : this.element.getProperties()) {
            if (!propertyPath.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public IObservable doGetObservable(String propertyPath) {
        Property property = this.findProperty(propertyPath);
        if (property == null) {
            return null;
        }
        if (property.getMultiplicity() == 1) {
            switch (property.getType()) {
                case BOOLEAN: {
                    return new CustomBooleanStyleObservableValue(this.view, this.domain, propertyPath);
                }
                case INTEGER: {
                    return new CustomIntStyleObservableValue(this.view, this.domain, propertyPath);
                }
                case REFERENCE: {
                    return new CustomEObjectStyleObservableValue(this.view, this.domain, propertyPath);
                }
                case STRING: {
                    return new CustomStringStyleObservableValue(this.view, this.domain, propertyPath);
                }
            }
            return null;
        }
        switch (property.getType()) {
            case BOOLEAN: {
                return new CustomBooleanStyleObservableList(this.view, this.domain, propertyPath);
            }
            case INTEGER: {
                return new CustomIntStyleObservableList(this.view, this.domain, propertyPath);
            }
            case REFERENCE: {
                return new CustomEObjectStyleObservableList(this.view, this.domain, propertyPath);
            }
            case STRING: {
                return new CustomStringStyleObservableList(this.view, this.domain, propertyPath);
            }
        }
        return null;
    }

    public boolean isEditable(String propertyPath) {
        return this.findProperty(propertyPath) != null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        return super.getContentProvider(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        return super.getLabelProvider(propertyPath);
    }

    public boolean isOrdered(String propertyPath) {
        return true;
    }

    public boolean isUnique(String propertyPath) {
        return false;
    }

    public boolean isMandatory(String propertyPath) {
        return false;
    }

    public boolean forceRefresh(String propertyPath) {
        return false;
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        Property property = this.findProperty(propertyPath);
        if (property == null) {
            return null;
        }
        switch (property.getType()) {
            case STRING: {
                return new StringEditionFactory();
            }
            case BOOLEAN: 
            case INTEGER: {
                return null;
            }
            case REFERENCE: {
                return null;
            }
        }
        return null;
    }

    public Object getDefaultValue(String propertyPath) {
        return null;
    }

    public boolean getDirectCreation(String propertyPath) {
        Property property = this.findProperty(propertyPath);
        if (property == null) {
            return false;
        }
        return property.getType() != Type.REFERENCE;
    }
}

