/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkEditorHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorHyperLinkEditorShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkEditorHelpersRegistrationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorHyperLinkHelper
extends AbstractHyperLinkHelper {
    @Override
    public String getNameofManagedHyperLink() {
        return Messages.EditorHyperLinkHelper_Editor;
    }

    @Override
    public void executeNewMousePressed(List<HyperLinkObject> list, EObject aModel) {
        IPageIconsRegistry editorRegistry = null;
        IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
        try {
            editorRegistry = (IPageIconsRegistry)papyrusEditor.getServicesRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        EditorHyperLinkEditorShell editor = new EditorHyperLinkEditorShell(editorRegistry, aModel);
        editor.open();
        if (editor.getHyperLinkEditor() != null) {
            list.add(editor.getHyperLinkEditor());
        }
    }

    @Override
    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperLinkObjects) {
        ArrayList<HyperLinkObject> result = new ArrayList<HyperLinkObject>();
        for (HyperLinkObject current : hyperLinkObjects) {
            if (!(current instanceof HyperLinkEditor)) continue;
            result.add(current);
        }
        return result;
    }

    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        return this.getHyperLinkObjectFor(eAnnotation);
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject HyperLinkObject2) {
        Collection<AbstractHyperLinkEditorHelper> helpers = HyperLinkEditorHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkEditorHelper();
        for (AbstractHyperLinkEditorHelper current : helpers) {
            CreateEAnnotationCommand cmd = current.getAddHyperLinkCommand(domain, object, HyperLinkObject2);
            if (cmd == null) continue;
            return cmd;
        }
        return null;
    }

    public HyperLinkEditor getHyperLinkObjectFor(Object editor) {
        Collection<AbstractHyperLinkEditorHelper> helpers = HyperLinkEditorHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkEditorHelper();
        for (AbstractHyperLinkEditorHelper current : helpers) {
            HyperLinkEditor object = current.getHyperLinkObjectFor(editor);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public HyperLinkEditor getHyperLinkObjectFor(EAnnotation eAnnotation) {
        Collection<AbstractHyperLinkEditorHelper> helpers = HyperLinkEditorHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkEditorHelper();
        for (AbstractHyperLinkEditorHelper current : helpers) {
            HyperLinkEditor object = current.getHyperLinkObjectForEAnnotation(eAnnotation);
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

